/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.SystemEventListenerFactory;
import org.jbpm.task.MockUserInfo;
import org.jbpm.task.UserInfo;
import org.jbpm.task.service.SendIcal;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.mina.MinaTaskServer;

public class RunTaskService {
    private EntityManagerFactory emf;
    private TaskService taskService;
    private TaskServiceSession taskSession;
    private MinaTaskServer server;

    public static void main(String[] args) throws Exception {
        new RunTaskService().start();
    }

    private void start() throws Exception {
        Properties conf = new Properties();
        conf.setProperty("mail.smtp.host", "localhost");
        conf.setProperty("mail.smtp.port", "2345");
        conf.setProperty("from", "from@domain.com");
        conf.setProperty("replyTo", "replyTo@domain.com");
        conf.setProperty("defaultLanguage", "en-UK");
        SendIcal.initInstance((Properties)conf);
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.task");
        this.taskService = new TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener());
        MockUserInfo userInfo = new MockUserInfo();
        this.taskService.setUserinfo((UserInfo)userInfo);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        InputStreamReader reader = new InputStreamReader(RunTaskService.class.getResourceAsStream("LoadUsers.mvel"));
        Map users = (Map)this.eval(reader, vars);
        reader = new InputStreamReader(RunTaskService.class.getResourceAsStream("LoadGroups.mvel"));
        Map groups = (Map)this.eval(reader, vars);
        this.taskService.addUsersAndGroups(users, groups);
        this.server = new MinaTaskServer(this.taskService);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        Thread.sleep(500L);
        System.out.println("Server started ...");
    }

    protected void stop() throws Exception {
        this.server.stop();
        this.taskSession.dispose();
        this.emf.close();
    }

    public Object eval(Reader reader, Map<String, Object> vars) {
        vars.put("now", new Date());
        return TaskService.eval((Reader)reader, vars);
    }
}

