/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.RollbackException;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Group;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.TaskService;
import org.jbpm.task.User;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.PermissionDeniedException;

public abstract class ClaimTaskTwiceTest
extends BaseTest {
    protected static org.jbpm.task.service.TaskService taskSessionFactory;
    protected long taskId;
    protected static final String GROUP_NAME = "Crusaders";
    protected ScheduledExecutorService execObj = null;
    protected int clientCount = 2;
    protected int delay = 0;
    protected static Set<String> claimersSet;
    protected boolean taskClaimedTwice = false;
    private static AtomicInteger threadIdGenerator;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        taskSessionFactory = this.taskService;
        logger.info("setUp() clientCount = " + this.clientCount + " : delay = " + this.delay);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private Task createTask() {
        Task task = new Task();
        TaskData tDataObj = new TaskData();
        task.setTaskData(tDataObj);
        Group groupObj = new Group(GROUP_NAME);
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.add(groupObj);
        PeopleAssignments peopleAssignmentObj = new PeopleAssignments();
        peopleAssignmentObj.setPotentialOwners(groups);
        task.setPeopleAssignments(peopleAssignmentObj);
        return task;
    }

    public void testDummy() {
    }

    public void testMultipleClientsOneTask() throws Exception {
        Task task = this.createTask();
        TaskService client = this.createClient("setup");
        client.addTask(task, new ContentData());
        this.cleanupClient(client);
        this.taskId = task.getId();
        logger.info("setUp() taskId = " + this.taskId);
        User[] userArray = new User[this.clientCount];
        String[] userNames = new String[]{"krisv", "john", "mary"};
        for (int t = 0; t < this.clientCount; ++t) {
            User user;
            userArray[t] = user = new User(userNames[t]);
        }
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add(GROUP_NAME);
        try {
            this.execObj = Executors.newScheduledThreadPool(this.clientCount);
            for (int t = 0; t < this.clientCount; ++t) {
                this.delay += t * this.delay;
                TaskOperationThread siClient = new TaskOperationThread(userArray[t].getId(), groupList);
                this.execObj.schedule(siClient, (long)this.delay, TimeUnit.MILLISECONDS);
            }
            this.execObj.shutdown();
            this.execObj.awaitTermination(60L, TimeUnit.SECONDS);
            logger.info("main() all tasks completed on ExecutorService ...");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ClaimTaskTwiceTest.assertTrue((String)("Task with task id " + this.taskId + " has been claimed twice!"), (!this.taskClaimedTwice ? 1 : 0) != 0);
    }

    protected TaskService createClient(String clientName) throws Exception {
        throw new UnsupportedOperationException("This must be implemented in the implementation test class!");
    }

    protected void cleanupClient(TaskService client) throws Exception {
        throw new UnsupportedOperationException("This must be implemented in the implementation test class!");
    }

    static /* synthetic */ AtomicInteger access$000() {
        return threadIdGenerator;
    }

    static {
        claimersSet = new CopyOnWriteArraySet<String>();
        threadIdGenerator = new AtomicInteger(0);
    }

    class TaskOperationThread
    implements Runnable {
        TaskService threadClient = null;
        final String threadName = "thread-" + ClaimTaskTwiceTest.access$000().incrementAndGet();
        String userId;
        List<String> groupList;

        public TaskOperationThread(String userId, List<String> groupList) {
            try {
                this.threadClient = ClaimTaskTwiceTest.this.createClient(this.threadName);
            }
            catch (Exception e) {
                logger.error("Could not initialize thread client: " + e.getClass().getSimpleName() + " [" + e.getMessage() + "]");
            }
            this.userId = userId;
            this.groupList = groupList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (int i = 0; i < 2 && !ClaimTaskTwiceTest.this.taskClaimedTwice; ++i) {
                    try {
                        this.threadClient.claim(ClaimTaskTwiceTest.this.taskId, this.userId, this.groupList);
                    }
                    catch (PermissionDeniedException pde) {
                        logger.debug("run() userId = " + this.userId + " : taskId = " + ClaimTaskTwiceTest.this.taskId + " : claimed by other user already!");
                        continue;
                    }
                    int numClaimers = 0;
                    Set<String> set = claimersSet;
                    synchronized (set) {
                        claimersSet.add(this.threadName);
                        numClaimers = claimersSet.size();
                    }
                    if (numClaimers > 1) {
                        ClaimTaskTwiceTest.this.taskClaimedTwice = true;
                    } else {
                        logger.info("run() just claimed task with userId = " + this.userId);
                    }
                    if (ClaimTaskTwiceTest.this.taskClaimedTwice) continue;
                    set = claimersSet;
                    synchronized (set) {
                        this.threadClient.release(ClaimTaskTwiceTest.this.taskId, this.userId);
                        claimersSet.remove(this.threadName);
                    }
                    Thread.sleep(500L);
                }
            }
            catch (RollbackException re) {
                Throwable secondCause = re.getCause().getCause();
                logger.error("run() userId = " + this.userId + " : taskId = " + ClaimTaskTwiceTest.this.taskId + " :  exception cause(s) = \n\t" + re.getCause() + "\n\t" + secondCause);
            }
            catch (PermissionDeniedException pde) {
                logger.error("run() userId = " + this.userId + " : taskId = " + ClaimTaskTwiceTest.this.taskId + " : claimed by other user already!");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                try {
                    ClaimTaskTwiceTest.this.cleanupClient(this.threadClient);
                }
                catch (Exception e) {}
            }
        }
    }
}

