/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.task.Content;
import org.jbpm.task.Deadline;
import org.jbpm.task.Task;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.TaskService;

public class MockEscalatedDeadlineHandler
implements EscalatedDeadlineHandler {
    List<Item> list = new ArrayList<Item>();
    TaskService taskService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeEscalatedDeadline(Task task, Deadline deadline, Content content, TaskService taskService) {
        List<Item> list = this.list;
        synchronized (list) {
            this.list.add(new Item(task, deadline, content, taskService));
            this.list.notifyAll();
        }
    }

    public List<Item> getList() {
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void wait(int totalSize, int totalWaitInMillis) throws Exception {
        long startInMillis = System.currentTimeMillis();
        int size = 0;
        boolean tries = false;
        while (true) {
            List<Item> list = this.list;
            synchronized (list) {
                size = this.list.size();
                if (this.list.size() < totalSize) {
                    this.list.wait(totalWaitInMillis);
                }
            }
            long waitInMillis = System.currentTimeMillis() - startInMillis;
            if (waitInMillis >= (long)totalWaitInMillis) {
                if (size < totalSize) continue;
                break;
            }
            Thread.sleep((long)totalWaitInMillis - waitInMillis);
        }
    }

    public static class Item {
        Task task;
        Deadline deadline;

        public Item(Task task, Deadline deadline, Content content, TaskService taskService) {
            this.deadline = deadline;
            this.task = task;
        }

        public Task getTask() {
            return this.task;
        }

        public void setTask(Task task) {
            this.task = task;
        }

        public Deadline getDeadline() {
            return this.deadline;
        }

        public void setDeadline(Deadline deadline) {
            this.deadline = deadline;
        }
    }
}

