/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.task.AccessType;
import org.jbpm.task.Attachment;
import org.jbpm.task.BaseTestNoUserGroupSetup;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.responsehandlers.BlockingAddAttachmentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingAddCommentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingDeleteAttachmentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingDeleteCommentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.jbpm.task.utils.CollectionUtils;

public abstract class TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest
extends BaseTestNoUserGroupSetup {
    protected TaskServer server;
    protected TaskClient client;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        super.tearDown();
    }

    public void testAddRemoveComment() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now}), ";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['darth'] ]}),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Comment comment = new Comment();
        Date addedAt = new Date(System.currentTimeMillis());
        comment.setAddedAt(addedAt);
        comment.setAddedBy((User)this.users.get("luke"));
        comment.setText("This is my comment1!!!!!");
        BlockingAddCommentResponseHandler addCommentResponseHandler = new BlockingAddCommentResponseHandler();
        this.client.addComment(taskId, comment, (TaskClientHandler.AddCommentResponseHandler)addCommentResponseHandler);
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertTrue((addCommentResponseHandler.getCommentId() != comment.getId().longValue() ? 1 : 0) != 0);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertNotSame((Object)task, (Object)task1);
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertFalse((boolean)task.equals((Object)task1));
        List comments1 = task1.getTaskData().getComments();
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((int)1, (int)comments1.size());
        Comment returnedComment = (Comment)comments1.get(0);
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((String)"This is my comment1!!!!!", (String)returnedComment.getText());
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((Object)addedAt, (Object)returnedComment.getAddedAt());
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals(this.users.get("luke"), (Object)returnedComment.getAddedBy());
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((long)addCommentResponseHandler.getCommentId(), (long)returnedComment.getId());
        task.getTaskData().setComments(comments1);
        task.getTaskData().setStatus(Status.Created);
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((Object)task, (Object)task1);
        comment = new Comment();
        addedAt = new Date(System.currentTimeMillis());
        comment.setAddedAt(addedAt);
        comment.setAddedBy((User)this.users.get("tony"));
        comment.setText("This is my comment2!!!!!");
        addCommentResponseHandler = new BlockingAddCommentResponseHandler();
        this.client.addComment(taskId, comment, (TaskClientHandler.AddCommentResponseHandler)addCommentResponseHandler);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        List comments2 = task1.getTaskData().getComments();
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((int)2, (int)comments2.size());
        comments1.add(comment);
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)comments1, (List)comments2));
        BlockingDeleteCommentResponseHandler deleteCommentResponseHandler = new BlockingDeleteCommentResponseHandler();
        this.client.deleteComment(taskId, addCommentResponseHandler.getCommentId(), (TaskClientHandler.DeleteCommentResponseHandler)deleteCommentResponseHandler);
        deleteCommentResponseHandler.waitTillDone(3000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        comments2 = task1.getTaskData().getComments();
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((int)1, (int)comments2.size());
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((String)"This is my comment1!!!!!", (String)((Comment)comments2.get(0)).getText());
    }

    public void testAddRemoveAttachment() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now}), ";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['darth'] ]}),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Attachment attachment = new Attachment();
        Date attachedAt = new Date(System.currentTimeMillis());
        attachment.setAttachedAt(attachedAt);
        attachment.setAttachedBy((User)this.users.get("luke"));
        attachment.setName("file1.txt");
        attachment.setAccessType(AccessType.Inline);
        attachment.setContentType("txt");
        byte[] bytes = "Ths is my attachment text1".getBytes();
        Content content = new Content();
        content.setContent(bytes);
        BlockingAddAttachmentResponseHandler addAttachmentResponseHandler = new BlockingAddAttachmentResponseHandler();
        this.client.addAttachment(taskId, attachment, content, (TaskClientHandler.AddAttachmentResponseHandler)addAttachmentResponseHandler);
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertTrue((addAttachmentResponseHandler.getAttachmentId() != attachment.getId().longValue() ? 1 : 0) != 0);
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertTrue((addAttachmentResponseHandler.getContentId() != attachment.getAttachmentContentId() ? 1 : 0) != 0);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertNotSame((Object)task, (Object)task1);
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertFalse((boolean)task.equals((Object)task1));
        List attachments1 = task1.getTaskData().getAttachments();
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((int)1, (int)attachments1.size());
        Attachment returnedAttachment = (Attachment)attachments1.get(0);
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((Object)attachedAt, (Object)returnedAttachment.getAttachedAt());
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals(this.users.get("luke"), (Object)returnedAttachment.getAttachedBy());
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((Object)AccessType.Inline, (Object)returnedAttachment.getAccessType());
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((String)"txt", (String)returnedAttachment.getContentType());
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((String)"file1.txt", (String)returnedAttachment.getName());
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((int)bytes.length, (int)returnedAttachment.getSize());
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((long)addAttachmentResponseHandler.getAttachmentId(), (long)returnedAttachment.getId());
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((long)addAttachmentResponseHandler.getContentId(), (long)returnedAttachment.getAttachmentContentId());
        task.getTaskData().setAttachments(attachments1);
        task.getTaskData().setStatus(Status.Created);
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((Object)task, (Object)task1);
        BlockingGetContentResponseHandler getResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(returnedAttachment.getAttachmentContentId(), (TaskClientHandler.GetContentResponseHandler)getResponseHandler);
        content = getResponseHandler.getContent();
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((String)"Ths is my attachment text1", (String)new String(content.getContent()));
        attachment = new Attachment();
        attachedAt = new Date(System.currentTimeMillis());
        attachment.setAttachedAt(attachedAt);
        attachment.setAttachedBy((User)this.users.get("tony"));
        attachment.setName("file2.txt");
        attachment.setAccessType(AccessType.Inline);
        attachment.setContentType("txt");
        bytes = "Ths is my attachment text2".getBytes();
        content = new Content();
        content.setContent(bytes);
        addAttachmentResponseHandler = new BlockingAddAttachmentResponseHandler();
        this.client.addAttachment(taskId, attachment, content, (TaskClientHandler.AddAttachmentResponseHandler)addAttachmentResponseHandler);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertNotSame((Object)task, (Object)task1);
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertFalse((boolean)task.equals((Object)task1));
        List attachments2 = task1.getTaskData().getAttachments();
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((int)2, (int)attachments2.size());
        getResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(addAttachmentResponseHandler.getContentId(), (TaskClientHandler.GetContentResponseHandler)getResponseHandler);
        content = getResponseHandler.getContent();
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((String)"Ths is my attachment text2", (String)new String(content.getContent()));
        attachment.setSize(26);
        attachment.setAttachmentContentId(addAttachmentResponseHandler.getContentId());
        attachments1.add(attachment);
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)attachments2, (List)attachments1));
        BlockingDeleteAttachmentResponseHandler deleteCommentResponseHandler = new BlockingDeleteAttachmentResponseHandler();
        this.client.deleteAttachment(taskId, addAttachmentResponseHandler.getAttachmentId(), addAttachmentResponseHandler.getContentId(), (TaskClientHandler.DeleteAttachmentResponseHandler)deleteCommentResponseHandler);
        deleteCommentResponseHandler.waitTillDone(3000L);
        Thread.sleep(3000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        attachments2 = task1.getTaskData().getAttachments();
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((int)1, (int)attachments2.size());
        TaskServiceCommentsAndAttachmentsBaseUserGroupCallbackTest.assertEquals((String)"file1.txt", (String)((Attachment)attachments2.get(0)).getName());
    }
}

