/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.drools.process.instance.impl.DefaultWorkItemManager;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Content;
import org.jbpm.task.MockUserInfo;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.service.DefaultEscalatedDeadlineHandler;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingSetContentResponseHandler;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public abstract class TaskServiceDeadlinesBaseTest
extends BaseTest {
    protected TaskServer server;
    protected TaskClient client;
    private Properties conf;
    private Wiser wiser;
    private static String emailAddressTony = "tony@domain.com";
    private static String emailAddressDarth = "darth@domain.com";

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        this.getWiser().stop();
        super.tearDown();
    }

    public void testDelayedEmailNotificationOnDeadline() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        DefaultEscalatedDeadlineHandler notificationHandler = new DefaultEscalatedDeadlineHandler(this.getConf());
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        notificationHandler.setManager((WorkItemManager)manager);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), emailAddressTony);
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("darth"), emailAddressDarth);
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("darth"), "en-UK");
        notificationHandler.setUserInfo((UserInfo)userInfo);
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)notificationHandler);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotification.mvel"));
        Task task = (Task)TaskServiceDeadlinesBaseTest.eval(reader, vars);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Content content = new Content();
        content.setContent("['subject' : 'My Subject', 'body' : 'My Body']".getBytes());
        BlockingSetContentResponseHandler setContentResponseHandler = new BlockingSetContentResponseHandler();
        this.client.setDocumentContent(taskId, content, (TaskClientHandler.SetDocumentResponseHandler)setContentResponseHandler);
        long contentId = setContentResponseHandler.getContentId();
        BlockingGetContentResponseHandler getResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getResponseHandler);
        content = getResponseHandler.getContent();
        TaskServiceDeadlinesBaseTest.assertEquals((String)"['subject' : 'My Subject', 'body' : 'My Body']", (String)new String(content.getContent()));
        TaskServiceDeadlinesBaseTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        TaskServiceDeadlinesBaseTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 15000L; time += 500L) {
            Thread.sleep(500L);
        }
        TaskServiceDeadlinesBaseTest.assertEquals((int)2, (int)this.getWiser().getMessages().size());
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(((WiserMessage)this.getWiser().getMessages().get(0)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.getWiser().getMessages().get(1)).getEnvelopeReceiver());
        TaskServiceDeadlinesBaseTest.assertTrue((boolean)list.contains(emailAddressTony));
        TaskServiceDeadlinesBaseTest.assertTrue((boolean)list.contains(emailAddressDarth));
        MimeMessage msg = ((WiserMessage)this.getWiser().getMessages().get(0)).getMimeMessage();
        TaskServiceDeadlinesBaseTest.assertEquals((Object)"My Body", (Object)msg.getContent());
        TaskServiceDeadlinesBaseTest.assertEquals((String)"My Subject", (String)msg.getSubject());
        TaskServiceDeadlinesBaseTest.assertEquals((String)"from@domain.com", (String)((InternetAddress)msg.getFrom()[0]).getAddress());
        TaskServiceDeadlinesBaseTest.assertEquals((String)"replyTo@domain.com", (String)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        boolean tonyMatched = false;
        boolean darthMatched = false;
        for (int i = 0; i < msg.getRecipients(MimeMessage.RecipientType.TO).length; ++i) {
            String emailAddress = ((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[i]).getAddress();
            if ("tony@domain.com".equals(emailAddress)) {
                tonyMatched = true;
                continue;
            }
            if (!"darth@domain.com".equals(emailAddress)) continue;
            darthMatched = true;
        }
        TaskServiceDeadlinesBaseTest.assertTrue((String)"Could not find tony in recipients list.", (boolean)tonyMatched);
        TaskServiceDeadlinesBaseTest.assertTrue((String)"Could not find darth in recipients list.", (boolean)darthMatched);
    }

    public void testDelayedReassignmentOnDeadline() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        DefaultEscalatedDeadlineHandler notificationHandler = new DefaultEscalatedDeadlineHandler(this.getConf());
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        notificationHandler.setManager((WorkItemManager)manager);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("luke"), "luke@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("bobba"), "luke@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("jabba"), "luke@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("luke"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("bobba"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("jabba"), "en-UK");
        notificationHandler.setUserInfo((UserInfo)userInfo);
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)notificationHandler);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithReassignment.mvel"));
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceDeadlinesBaseTest.eval(reader, vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Thread.sleep(1000L);
        BlockingGetTaskResponseHandler getTaskHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskHandler);
        task = getTaskHandler.getTask();
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ArrayList<String> ids = new ArrayList<String>(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        TaskServiceDeadlinesBaseTest.assertTrue((boolean)ids.contains(((User)this.users.get("tony")).getId()));
        TaskServiceDeadlinesBaseTest.assertTrue((boolean)ids.contains(((User)this.users.get("luke")).getId()));
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 15000L; time += 500L) {
            Thread.sleep(500L);
        }
        getTaskHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskHandler);
        task = getTaskHandler.getTask();
        TaskServiceDeadlinesBaseTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        logger.debug(potentialOwners.toString());
        ids = new ArrayList(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        TaskServiceDeadlinesBaseTest.assertTrue((boolean)ids.contains(((User)this.users.get("bobba")).getId()));
        TaskServiceDeadlinesBaseTest.assertTrue((boolean)ids.contains(((User)this.users.get("jabba")).getId()));
    }

    public void setConf(Properties conf) {
        this.conf = conf;
    }

    public Properties getConf() {
        return this.conf;
    }

    public void setWiser(Wiser wiser) {
        this.wiser = wiser;
    }

    public Wiser getWiser() {
        return this.wiser;
    }
}

