/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.async;

import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.utils.CollectionUtils;

public abstract class TaskServiceBaseAsyncTest
extends BaseTest {
    protected TaskServer server;
    protected AsyncTaskService client;

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        super.tearDown();
    }

    public void testTasksOwnedQueryWithI18N() throws Exception {
        HashMap<String, Map> vars = new HashMap<String, Map>();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/QueryData_TasksOwned.mvel"));
        List tasks = (List)TaskServiceBaseAsyncTest.eval(reader, vars);
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler responseHandler = new BlockingAddTaskResponseHandler();
            this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)responseHandler);
        }
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/QueryResults_TasksOwnedInEnglish.mvel"));
        Map expected = (Map)TaskServiceBaseAsyncTest.eval(reader, vars);
        BlockingAllOpenTasksForUseResponseHandler responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksOwned(((User)this.users.get("peter")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List<TaskSummary> actual = responseHandler.getResults();
        TaskServiceBaseAsyncTest.assertEquals((int)3, (int)actual.size());
        TaskServiceBaseAsyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("peter")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksOwned(((User)this.users.get("steve")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseAsyncTest.assertEquals((int)2, (int)actual.size());
        TaskServiceBaseAsyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksOwned(((User)this.users.get("darth")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseAsyncTest.assertEquals((int)1, (int)actual.size());
        TaskServiceBaseAsyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), actual));
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/QueryResults_TasksOwnedInGerman.mvel"));
        expected = (Map)TaskServiceBaseAsyncTest.eval(reader, vars);
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksOwned(((User)this.users.get("peter")).getId(), "en-DK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseAsyncTest.assertEquals((int)3, (int)actual.size());
        TaskServiceBaseAsyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("peter")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksOwned(((User)this.users.get("steve")).getId(), "en-DK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseAsyncTest.assertEquals((int)2, (int)actual.size());
        TaskServiceBaseAsyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksOwned(((User)this.users.get("darth")).getId(), "en-DK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseAsyncTest.assertEquals((int)1, (int)actual.size());
        TaskServiceBaseAsyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), actual));
    }

    public void testPotentialOwnerQueries() {
        HashMap<String, Map> vars = new HashMap<String, Map>();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/QueryData_TasksPotentialOwner.mvel"));
        List tasks = (List)TaskServiceBaseAsyncTest.eval(reader, vars);
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler responseHandler = new BlockingAddTaskResponseHandler();
            this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)responseHandler);
        }
        BlockingAllOpenTasksForUseResponseHandler responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List<TaskSummary> actual = responseHandler.getResults();
        TaskServiceBaseAsyncTest.assertEquals((int)2, (int)actual.size());
    }

    public void testPeopleAssignmentQueries() {
        Map<String, Object> vars = this.fillVariables();
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/QueryData_TasksOwned.mvel"));
        List tasks = (List)TaskServiceBaseAsyncTest.eval(reader, vars);
        for (Task task : tasks) {
            this.taskSession.addTask(task, null);
        }
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/QueryResults_PeopleAssignmentQuerries.mvel"));
        Map expected = (Map)TaskServiceBaseAsyncTest.eval(reader, vars);
        BlockingAllOpenTasksForUseResponseHandler responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksAssignedAsTaskInitiator(((User)this.users.get("darth")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List<TaskSummary> actual = responseHandler.getResults();
        TaskServiceBaseAsyncTest.assertEquals((int)1, (int)actual.size());
        TaskServiceBaseAsyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksAssignedAsBusinessAdministrator(((User)this.users.get("steve")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseAsyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksAssignedAsExcludedOwner(((User)this.users.get("liz")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseAsyncTest.assertEquals((int)2, (int)actual.size());
        TaskServiceBaseAsyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("liz")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseAsyncTest.assertEquals((int)3, (int)actual.size());
        TaskServiceBaseAsyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("bobba")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        this.client.getTasksAssignedAsRecipient(((User)this.users.get("sly")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseAsyncTest.assertEquals((int)1, (int)actual.size());
        TaskServiceBaseAsyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("sly")), actual));
    }

    public static class BlockingAllOpenTasksForUseResponseHandler
    implements TaskClientHandler.TaskSummaryResponseHandler {
        private volatile List<TaskSummary> results;
        private volatile RuntimeException error;

        public synchronized void execute(List<TaskSummary> results) {
            this.results = results;
            this.notifyAll();
        }

        public synchronized List<TaskSummary> getResults() {
            if (this.results == null) {
                try {
                    this.wait(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.results == null) {
                throw new RuntimeException("Timeout : unable to retrieve results");
            }
            return this.results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDone() {
            List<TaskSummary> list = this.results;
            synchronized (list) {
                return this.results != null;
            }
        }

        public void setError(RuntimeException error) {
            this.error = error;
        }

        public RuntimeException getError() {
            return this.error;
        }
    }
}

