/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.async;

import java.io.StringReader;
import java.util.Map;
import org.jbpm.task.AccessType;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskServiceTaskAttributesBaseTest;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;

public abstract class TaskServiceTaskAttributesBaseAsyncTest
extends BaseTest {
    protected TaskServer server;
    protected AsyncTaskService client;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        super.tearDown();
    }

    public void testAddRemoveOutput() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now,";
        str = str + "actualOwner = new User('Darth Vader')}),";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = new PeopleAssignments(),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceTaskAttributesBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        ContentData outputData = new ContentData();
        outputData.setAccessType(AccessType.Inline);
        outputData.setContent("This is my output!!!!".getBytes());
        outputData.setType("text/plain");
        BlockingTaskOperationResponseHandler setOutputResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.setOutput(taskId, "Darth Vader", outputData, (TaskClientHandler.TaskOperationResponseHandler)setOutputResponseHandler);
        setOutputResponseHandler.waitTillDone(1000L);
        TaskServiceTaskAttributesBaseAsyncTest.assertFalse((boolean)setOutputResponseHandler.hasError());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceTaskAttributesBaseAsyncTest.assertNotSame((Object)task, (Object)task1);
        TaskServiceTaskAttributesBaseAsyncTest.assertFalse((boolean)task.equals((Object)task1));
        long outputContentId = task1.getTaskData().getOutputContentId();
        TaskServiceTaskAttributesBaseAsyncTest.assertNotSame((Object)0, (Object)outputContentId);
        BlockingGetContentResponseHandler getOutputResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(outputContentId, (TaskClientHandler.GetContentResponseHandler)getOutputResponseHandler);
        TaskServiceTaskAttributesBaseAsyncTest.assertNotNull((Object)getOutputResponseHandler.getContent());
        Content content = getOutputResponseHandler.getContent();
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((String)"This is my output!!!!", (String)new String(content.getContent()));
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((String)"text/plain", (String)task1.getTaskData().getOutputType());
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getOutputAccessType());
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((long)outputContentId, (long)content.getId());
        task.getTaskData().setOutput(outputContentId, outputData);
        task.getTaskData().setStatus(Status.Created);
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((Object)task, (Object)task1);
        BlockingTaskOperationResponseHandler deleteOutputResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.deleteOutput(taskId, "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)deleteOutputResponseHandler);
        deleteOutputResponseHandler.waitTillDone(1000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((long)0L, (long)task1.getTaskData().getOutputContentId());
        TaskServiceTaskAttributesBaseAsyncTest.assertNull((Object)task1.getTaskData().getOutputAccessType());
        TaskServiceTaskAttributesBaseAsyncTest.assertNull((Object)task1.getTaskData().getOutputType());
    }

    public void testAddRemoveFault() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now,";
        str = str + "actualOwner = new User('Darth Vader')}),";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = new PeopleAssignments(),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceTaskAttributesBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        FaultData faultData = new FaultData();
        faultData.setAccessType(AccessType.Inline);
        faultData.setContent("This is my fault!!!!".getBytes());
        faultData.setFaultName("fault1");
        faultData.setType("text/plain");
        BlockingTaskOperationResponseHandler setFaultResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.setFault(taskId, "Darth Vader", faultData, (TaskClientHandler.TaskOperationResponseHandler)setFaultResponseHandler);
        setFaultResponseHandler.waitTillDone(1000L);
        TaskServiceTaskAttributesBaseAsyncTest.assertFalse((boolean)setFaultResponseHandler.hasError());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceTaskAttributesBaseAsyncTest.assertNotSame((Object)task, (Object)task1);
        TaskServiceTaskAttributesBaseAsyncTest.assertFalse((boolean)task.equals((Object)task1));
        long faultContentId = task1.getTaskData().getFaultContentId();
        TaskServiceTaskAttributesBaseAsyncTest.assertNotSame((Object)0, (Object)faultContentId);
        BlockingGetContentResponseHandler getFaultResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(faultContentId, (TaskClientHandler.GetContentResponseHandler)getFaultResponseHandler);
        TaskServiceTaskAttributesBaseAsyncTest.assertNotNull((Object)getFaultResponseHandler.getContent());
        Content content = getFaultResponseHandler.getContent();
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((String)"This is my fault!!!!", (String)new String(content.getContent()));
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((String)"text/plain", (String)task1.getTaskData().getFaultType());
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((String)"fault1", (String)task1.getTaskData().getFaultName());
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getFaultAccessType());
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((long)faultContentId, (long)content.getId());
        task.getTaskData().setOutput(faultContentId, (ContentData)faultData);
        task.getTaskData().setStatus(Status.Created);
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((Object)task, (Object)task1);
        BlockingTaskOperationResponseHandler deleteFaultResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.deleteFault(taskId, "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)deleteFaultResponseHandler);
        deleteFaultResponseHandler.waitTillDone(1000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        TaskServiceTaskAttributesBaseAsyncTest.assertEquals((long)0L, (long)task1.getTaskData().getFaultContentId());
        TaskServiceTaskAttributesBaseAsyncTest.assertNull((Object)task1.getTaskData().getFaultAccessType());
        TaskServiceTaskAttributesBaseAsyncTest.assertNull((Object)task1.getTaskData().getFaultType());
        TaskServiceTaskAttributesBaseAsyncTest.assertNull((Object)task1.getTaskData().getFaultName());
    }

    public void testSetPriority() throws Exception {
        TaskServiceTaskAttributesBaseTest.testSetPriority(this.fillVariables(), this.client);
    }
}

