/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.sync;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;
import org.jbpm.task.User;
import org.jbpm.task.event.TaskCompletedEvent;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.responsehandlers.BlockingEventResponseHandler;

public abstract class TaskLifeCycleBaseSyncTest
extends BaseTest {
    protected TaskServer server;
    protected TaskService client;

    @Override
    protected void tearDown() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
        if (this.server != null) {
            this.server.stop();
        }
        super.tearDown();
    }

    public void testLifeCycle() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        vars.put("now", new Date());
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { workItemId = 1 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba']], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, taskId);
        BlockingEventResponseHandler handler = new BlockingEventResponseHandler();
        this.client.registerForEvent((EventKey)key, true, (EventResponseHandler)handler);
        List tasks = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK");
        TaskLifeCycleBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)((TaskSummary)tasks.get(0)).getStatus());
        this.client.start(taskId, ((User)this.users.get("bobba")).getId());
        tasks = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK");
        TaskLifeCycleBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)((TaskSummary)tasks.get(0)).getStatus());
        this.client.complete(taskId, ((User)this.users.get("bobba")).getId(), null);
        Thread.sleep(500L);
        Date completedBy = new Date();
        tasks = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK");
        TaskLifeCycleBaseSyncTest.assertEquals((int)0, (int)tasks.size());
        Payload payload = handler.getPayload();
        TaskCompletedEvent event = (TaskCompletedEvent)payload.get();
        TaskLifeCycleBaseSyncTest.assertNotNull((Object)event);
        Task task1 = this.client.getTask(taskId);
        TaskLifeCycleBaseSyncTest.assertEquals((Object)Status.Completed, (Object)task1.getTaskData().getStatus());
        Date completedOn = task1.getTaskData().getCompletedOn();
        TaskLifeCycleBaseSyncTest.assertTrue((String)"Completed on date was empty!", (completedOn != null ? 1 : 0) != 0);
        TaskLifeCycleBaseSyncTest.assertTrue((String)"Completed on date is incorrect.", (boolean)completedBy.after(completedOn));
    }

    public void testLifeCycleMultipleTasks() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { workItemId = 1 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba']], }),";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my description')], ";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my subject')], ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, taskId);
        BlockingEventResponseHandler handler = new BlockingEventResponseHandler();
        this.client.registerForEvent((EventKey)key, true, (EventResponseHandler)handler);
        List tasks = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK");
        TaskLifeCycleBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)((TaskSummary)tasks.get(0)).getStatus());
        this.client.start(taskId, ((User)this.users.get("bobba")).getId());
        tasks = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK");
        TaskLifeCycleBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)((TaskSummary)tasks.get(0)).getStatus());
        Task task2 = (Task)TaskLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task2, null);
        long taskId2 = task2.getId();
        TaskEventKey key2 = new TaskEventKey(TaskCompletedEvent.class, taskId2);
        BlockingEventResponseHandler handler2 = new BlockingEventResponseHandler();
        this.client.registerForEvent((EventKey)key2, true, (EventResponseHandler)handler2);
        tasks = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK");
        TaskLifeCycleBaseSyncTest.assertEquals((int)2, (int)tasks.size());
        this.client.complete(taskId, ((User)this.users.get("bobba")).getId(), null);
        this.client.start(taskId2, ((User)this.users.get("bobba")).getId());
        tasks = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK");
        TaskLifeCycleBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        Payload payload = handler.getPayload();
        TaskCompletedEvent event = (TaskCompletedEvent)payload.get();
        TaskLifeCycleBaseSyncTest.assertNotNull((Object)event);
        task = this.client.getTask(taskId);
        TaskLifeCycleBaseSyncTest.assertEquals((Object)Status.Completed, (Object)task.getTaskData().getStatus());
        this.client.complete(taskId2, ((User)this.users.get("bobba")).getId(), null);
        payload = handler2.getPayload();
        event = (TaskCompletedEvent)payload.get();
        TaskLifeCycleBaseSyncTest.assertNotNull((Object)event);
        task2 = this.client.getTask(taskId2);
        TaskLifeCycleBaseSyncTest.assertEquals((Object)Status.Completed, (Object)task2.getTaskData().getStatus());
    }

    private static class MyWorkItemManager
    implements WorkItemManager {
        private List<Long> completed = new ArrayList<Long>();
        private List<Long> aborted = new ArrayList<Long>();

        private MyWorkItemManager() {
        }

        public List<Long> getAborted() {
            return this.aborted;
        }

        public List<Long> getCompleted() {
            return this.completed;
        }

        public void completeWorkItem(long l, Map<String, Object> map) {
            logger.debug("WorkItem Completed");
            this.completed.add(l);
        }

        public void abortWorkItem(long l) {
            logger.debug("WorkItem Aborted");
            this.aborted.add(l);
        }

        public void registerWorkItemHandler(String string, WorkItemHandler wih) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

