/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.sync;

import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;
import org.jbpm.task.User;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.utils.CollectionUtils;

public abstract class TaskServiceBaseSyncTest
extends BaseTest {
    protected TaskServer server;
    protected TaskService client;

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        super.tearDown();
    }

    public void testTasksOwnedQueryWithI18N() throws Exception {
        HashMap<String, Map> vars = new HashMap<String, Map>();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/QueryData_TasksOwned.mvel"));
        List tasks = (List)TaskServiceBaseSyncTest.eval(reader, vars);
        for (Task task : tasks) {
            this.client.addTask(task, null);
        }
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/QueryResults_TasksOwnedInEnglish.mvel"));
        Map expected = (Map)TaskServiceBaseSyncTest.eval(reader, vars);
        List actual = this.client.getTasksOwned(((User)this.users.get("peter")).getId(), "en-UK");
        TaskServiceBaseSyncTest.assertEquals((int)3, (int)actual.size());
        TaskServiceBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("peter")), (List)actual));
        actual = this.client.getTasksOwned(((User)this.users.get("steve")).getId(), "en-UK");
        TaskServiceBaseSyncTest.assertEquals((int)2, (int)actual.size());
        TaskServiceBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), (List)actual));
        actual = this.client.getTasksOwned(((User)this.users.get("darth")).getId(), "en-UK");
        TaskServiceBaseSyncTest.assertEquals((int)1, (int)actual.size());
        TaskServiceBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), (List)actual));
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/QueryResults_TasksOwnedInGerman.mvel"));
        expected = (Map)TaskServiceBaseSyncTest.eval(reader, vars);
        actual = this.client.getTasksOwned(((User)this.users.get("peter")).getId(), "en-DK");
        TaskServiceBaseSyncTest.assertEquals((int)3, (int)actual.size());
        TaskServiceBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("peter")), (List)actual));
        actual = this.client.getTasksOwned(((User)this.users.get("steve")).getId(), "en-DK");
        TaskServiceBaseSyncTest.assertEquals((int)2, (int)actual.size());
        TaskServiceBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), (List)actual));
        actual = this.client.getTasksOwned(((User)this.users.get("darth")).getId(), "en-DK");
        TaskServiceBaseSyncTest.assertEquals((int)1, (int)actual.size());
        TaskServiceBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), (List)actual));
    }

    public void testPotentialOwnerQueries() {
        HashMap<String, Map> vars = new HashMap<String, Map>();
        vars.put("users", this.users);
        vars.put("groups", this.groups);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/QueryData_TasksPotentialOwner.mvel"));
        List tasks = (List)TaskServiceBaseSyncTest.eval(reader, vars);
        for (Task task : tasks) {
            this.client.addTask(task, null);
        }
        List actual = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK");
        TaskServiceBaseSyncTest.assertEquals((int)2, (int)actual.size());
    }

    public void testPeopleAssignmentQueries() {
        Map<String, Object> vars = this.fillVariables();
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/QueryData_TasksOwned.mvel"));
        List tasks = (List)TaskServiceBaseSyncTest.eval(reader, vars);
        for (Task task : tasks) {
            this.taskSession.addTask(task, null);
        }
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/QueryResults_PeopleAssignmentQuerries.mvel"));
        Map expected = (Map)TaskServiceBaseSyncTest.eval(reader, vars);
        List actual = this.client.getTasksAssignedAsTaskInitiator(((User)this.users.get("darth")).getId(), "en-UK");
        TaskServiceBaseSyncTest.assertEquals((int)1, (int)actual.size());
        TaskServiceBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), (List)actual));
        actual = this.client.getTasksAssignedAsBusinessAdministrator(((User)this.users.get("steve")).getId(), "en-UK");
        TaskServiceBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), (List)actual));
        actual = this.client.getTasksAssignedAsExcludedOwner(((User)this.users.get("liz")).getId(), "en-UK");
        TaskServiceBaseSyncTest.assertEquals((int)2, (int)actual.size());
        TaskServiceBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("liz")), (List)actual));
        actual = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK");
        TaskServiceBaseSyncTest.assertEquals((int)3, (int)actual.size());
        TaskServiceBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("bobba")), (List)actual));
        actual = this.client.getTasksAssignedAsRecipient(((User)this.users.get("sly")).getId(), "en-UK");
        TaskServiceBaseSyncTest.assertEquals((int)1, (int)actual.size());
        TaskServiceBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("sly")), (List)actual));
    }

    public static class BlockingAllOpenTasksForUseResponseHandler
    implements TaskClientHandler.TaskSummaryResponseHandler {
        private volatile List<TaskSummary> results;
        private volatile RuntimeException error;

        public synchronized void execute(List<TaskSummary> results) {
            this.results = results;
            this.notifyAll();
        }

        public synchronized List<TaskSummary> getResults() {
            if (this.results == null) {
                try {
                    this.wait(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.results == null) {
                throw new RuntimeException("Timeout : unable to retrieve results");
            }
            return this.results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDone() {
            List<TaskSummary> list = this.results;
            synchronized (list) {
                return this.results != null;
            }
        }

        public void setError(RuntimeException error) {
            this.error = error;
        }

        public RuntimeException getError() {
            return this.error;
        }
    }
}

