/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.sync;

import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Map;
import org.jbpm.task.AccessType;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.TaskServer;

public abstract class TaskServiceTaskAttributesBaseSyncTest
extends BaseTest {
    protected TaskServer server;
    protected TaskService client;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        if (this.server != null) {
            this.server.stop();
        }
        super.tearDown();
    }

    public void testAddRemoveOutput() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now,";
        str = str + "actualOwner = new User('Darth Vader')}),";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = new PeopleAssignments(),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceTaskAttributesBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        ContentData outputData = new ContentData();
        outputData.setAccessType(AccessType.Inline);
        outputData.setContent("This is my output!!!!".getBytes());
        outputData.setType("text/plain");
        this.client.setOutput(taskId, "Darth Vader", outputData);
        Task task1 = this.client.getTask(taskId);
        long outputContentId = task1.getTaskData().getOutputContentId();
        TaskServiceTaskAttributesBaseSyncTest.assertNotSame((Object)0, (Object)outputContentId);
        Content content = this.client.getContent(outputContentId);
        TaskServiceTaskAttributesBaseSyncTest.assertNotNull((Object)content);
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((String)"This is my output!!!!", (String)new String(content.getContent()));
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((String)"text/plain", (String)task1.getTaskData().getOutputType());
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getOutputAccessType());
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((long)outputContentId, (long)content.getId());
        task.getTaskData().setOutput(outputContentId, outputData);
        this.testThatTasksAreEqual(task, task1);
        this.client.deleteOutput(taskId, "Darth Vader");
        task1 = this.client.getTask(taskId);
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((long)0L, (long)task1.getTaskData().getOutputContentId());
        TaskServiceTaskAttributesBaseSyncTest.assertNull((Object)task1.getTaskData().getOutputAccessType());
        TaskServiceTaskAttributesBaseSyncTest.assertNull((Object)task1.getTaskData().getOutputType());
    }

    public void testAddRemoveFault() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now,";
        str = str + "actualOwner = new User('Darth Vader')}),";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = new PeopleAssignments(),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceTaskAttributesBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        FaultData faultData = new FaultData();
        faultData.setAccessType(AccessType.Inline);
        faultData.setContent("This is my fault!!!!".getBytes());
        faultData.setFaultName("fault1");
        faultData.setType("text/plain");
        this.client.setFault(taskId, "Darth Vader", faultData);
        Task task1 = this.client.getTask(taskId);
        long faultContentId = task1.getTaskData().getFaultContentId();
        TaskServiceTaskAttributesBaseSyncTest.assertNotSame((Object)0, (Object)faultContentId);
        Content content = this.client.getContent(faultContentId);
        TaskServiceTaskAttributesBaseSyncTest.assertNotNull((Object)content);
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((String)"This is my fault!!!!", (String)new String(content.getContent()));
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((String)"text/plain", (String)task1.getTaskData().getFaultType());
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((String)"fault1", (String)task1.getTaskData().getFaultName());
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getFaultAccessType());
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((long)faultContentId, (long)content.getId());
        task.getTaskData().setOutput(faultContentId, (ContentData)faultData);
        this.testThatTasksAreEqual(task, task1);
        this.client.deleteFault(taskId, "Darth Vader");
        task1 = this.client.getTask(taskId);
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((long)0L, (long)task1.getTaskData().getFaultContentId());
        TaskServiceTaskAttributesBaseSyncTest.assertNull((Object)task1.getTaskData().getFaultAccessType());
        TaskServiceTaskAttributesBaseSyncTest.assertNull((Object)task1.getTaskData().getFaultType());
        TaskServiceTaskAttributesBaseSyncTest.assertNull((Object)task1.getTaskData().getFaultName());
    }

    public void testSetPriority() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now,";
        str = str + "actualOwner = new User('Darth Vader')}),";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = new PeopleAssignments(),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceTaskAttributesBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        int newPriority = 33;
        this.client.setPriority(taskId, "Darth Vader", newPriority);
        Task task1 = this.client.getTask(taskId);
        int newPriority1 = task1.getPriority();
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((int)newPriority, (int)newPriority1);
        task.setPriority(newPriority);
        this.testThatTasksAreEqual(task, task1);
    }

    private void testThatTasksAreEqual(Task task, Task task1) {
        task.getTaskData().setStatus(Status.Created);
        try {
            Field versionField = Task.class.getDeclaredField("version");
            versionField.setAccessible(true);
            versionField.setInt(task, 0);
            versionField.setInt(task1, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            TaskServiceTaskAttributesBaseSyncTest.fail((String)e.getLocalizedMessage());
        }
        TaskServiceTaskAttributesBaseSyncTest.assertEquals((Object)task, (Object)task1);
    }
}

