/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.hornetq;

import org.drools.SystemEventListenerFactory;
import org.drools.util.ChainedProperties;
import org.drools.util.ClassLoaderUtil;
import org.jbpm.task.service.BaseClientHandler;
import org.jbpm.task.service.IcalBaseTest;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.hornetq.HornetQTaskClientConnector;
import org.jbpm.task.service.hornetq.HornetQTaskClientHandler;
import org.jbpm.task.service.hornetq.HornetQTaskServer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.subethamail.wiser.Wiser;

public class IcalHornetQTest
extends IcalBaseTest {
    @Override
    @BeforeClass
    protected void setUp() throws Exception {
        super.setUp();
        ChainedProperties props = new ChainedProperties("process.email.conf", (ClassLoader)ClassLoaderUtil.getClassLoader(null, ((Object)((Object)this)).getClass(), (boolean)false));
        this.setEmailHost(props.getProperty("host", "locahost"));
        this.setEmailPort(props.getProperty("port", "2345"));
        this.server = new HornetQTaskServer(this.taskService, 5153);
        logger.debug("Waiting for the HornetQTask Server to come up");
        try {
            this.startTaskServerThread(this.server, false);
        }
        catch (Exception e) {
            this.startTaskServerThread(this.server, true);
        }
        this.client = new TaskClient((TaskClientConnector)new HornetQTaskClientConnector("client 1", (BaseClientHandler)new HornetQTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
        this.client.connect("127.0.0.1", 5153);
        this.setWiser(new Wiser());
        this.getWiser().setHostname(this.getEmailHost());
        this.getWiser().setPort(Integer.parseInt(this.getEmailPort()));
        this.getWiser().start();
    }

    @Override
    @AfterClass
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        this.getWiser().stop();
        super.tearDown();
    }
}

