/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.jms.async;

import java.util.Properties;
import javax.naming.Context;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.drools.SystemEventListenerFactory;
import org.easymock.EasyMock;
import org.jbpm.task.service.BaseClientHandler;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.base.async.TaskServiceBaseAsyncTest;
import org.jbpm.task.service.jms.JMSTaskClientConnector;
import org.jbpm.task.service.jms.JMSTaskClientHandler;
import org.jbpm.task.service.jms.JMSTaskServer;

public class TaskServiceJMSAsyncTest
extends TaskServiceBaseAsyncTest {
    private Context context;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.context = (Context)EasyMock.createMock(Context.class);
        EasyMock.expect((Object)this.context.lookup("ConnectionFactory")).andReturn((Object)factory).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.context});
        Properties serverProperties = new Properties();
        serverProperties.setProperty("JMSTaskServer.connectionFactory", "ConnectionFactory");
        serverProperties.setProperty("JMSTaskServer.transacted", "true");
        serverProperties.setProperty("JMSTaskServer.acknowledgeMode", "AUTO_ACKNOWLEDGE");
        serverProperties.setProperty("JMSTaskServer.queueName", "tasksQueue");
        serverProperties.setProperty("JMSTaskServer.responseQueueName", "tasksResponseQueue");
        this.server = new JMSTaskServer(this.taskService, serverProperties, this.context);
        logger.debug("Waiting for the JMS Task Server to come up");
        try {
            this.startTaskServerThread(this.server, false);
        }
        catch (Exception e) {
            this.startTaskServerThread(this.server, true);
        }
        Properties clientProperties = new Properties();
        clientProperties.setProperty("JMSTaskClient.connectionFactory", "ConnectionFactory");
        clientProperties.setProperty("JMSTaskClient.transactedQueue", "true");
        clientProperties.setProperty("JMSTaskClient.acknowledgeMode", "AUTO_ACKNOWLEDGE");
        clientProperties.setProperty("JMSTaskClient.queueName", "tasksQueue");
        clientProperties.setProperty("JMSTaskClient.responseQueueName", "tasksResponseQueue");
        this.client = new TaskClient((TaskClientConnector)new JMSTaskClientConnector("client 1", (BaseClientHandler)new JMSTaskClientHandler(SystemEventListenerFactory.getSystemEventListener()), clientProperties, this.context));
        this.client.connect();
    }
}

