/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.test.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jbpm.task.service.BaseClientHandler;
import org.jbpm.task.service.BaseHandler;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.test.impl.TestServerUtil;
import org.jbpm.task.service.test.impl.TestTaskClientHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestTaskClientConnector
implements TaskClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(TestTaskClientConnector.class);
    private volatile AtomicBoolean running;
    private volatile CountDownLatch finished;
    private BaseClientHandler handler;
    private String name;
    private AtomicInteger counter;
    private BlockingQueue<byte[]> producer;
    private BlockingQueue<byte[]> consumer;

    public TestTaskClientConnector(String name, BaseClientHandler handler) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = name;
        this.handler = handler;
        this.counter = new AtomicInteger();
    }

    public boolean connect(String address, int port) {
        return this.connect();
    }

    public boolean connect() {
        Thread responsesThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (TestTaskClientConnector.this.running.get()) {
                        byte[] messageBytes = (byte[])TestTaskClientConnector.this.consumer.take();
                        if (messageBytes == null || messageBytes.length <= 0) continue;
                        TestServerUtil.pause();
                        Object serverMessage = TestServerUtil.deserialize(messageBytes);
                        ((TestTaskClientHandler)TestTaskClientConnector.this.handler).messageReceived(TestTaskClientConnector.this.producer, serverMessage);
                    }
                    TestTaskClientConnector.this.finished.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.info(e.getMessage());
                    throw new RuntimeException("Client Exception with class " + this.getClass(), e);
                }
            }
        });
        responsesThread.start();
        return true;
    }

    public void disconnect() throws Exception {
        this.consumer.put(new byte[0]);
    }

    public void write(Object object) {
        try {
            TestServerUtil.pause();
            byte[] messageBytes = TestServerUtil.serialize(object);
            this.producer.put(messageBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing message", e);
        }
    }

    public BaseHandler getHandler() {
        return this.handler;
    }

    public String getName() {
        return this.name;
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public void setQueues(BlockingQueue<byte[]>[] queues) {
        this.producer = queues[0];
        this.consumer = queues[1];
    }

    public void setFlags(Object[] flags) {
        this.running = (AtomicBoolean)flags[0];
        this.finished = (CountDownLatch)flags[1];
    }
}

