/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dependencies.hib4;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.DependencyResolvers;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.jbpm.dependencies.hib4.Hibernate4PackagingTest;
import org.junit.Test;

public class Hib4H2PackagingTest
extends Hibernate4PackagingTest {
    @Test
    public void runTestsUnderHibernate4Jpa2H2() throws Exception {
        File humanTaskJar = this.buildH2Jpa2Hiberate4Jar();
        ProcessBuilder procBldr = Hib4H2PackagingTest.buildProcessBuilder(humanTaskJar.getAbsolutePath(), this.resolveH2JarsForClassPath());
        Process testProcess = procBldr.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(testProcess.getInputStream()));
        String line = null;
        while ((line = in.readLine()) != null) {
            System.out.println(line);
        }
        int exitValue = testProcess.waitFor();
        if (exitValue != 0) {
            Assert.fail((String)("Tests did not succeed [ exit == " + exitValue + "]"));
        }
    }

    private File buildH2Jpa2Hiberate4Jar() throws IOException {
        String fileName = "h2Hib4.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)fileName);
        HashMap<String, String> targetFileMap = new HashMap<String, String>();
        targetFileMap.put("META-INF/persistence.xml", "package/jpa2/h2/persistence.xml");
        targetFileMap.put("datasource.properties", "package/jpa2/h2/datasource.properties");
        targetFileMap.put("META-INF/Taskorm-JPA2.xml", "package/jpa2/Taskorm-JPA2.xml");
        targetFileMap.put("log4j.xml", "package/hib4/log4j.xml");
        targetFileMap.put("jbpm.usergroup.callback.properties", "jbpm.usergroup.callback.properties");
        Set<String> mvelFiles = Hib4H2PackagingTest.getMvelFilePaths();
        for (String mvelFile : mvelFiles) {
            targetFileMap.put(mvelFile, mvelFile);
        }
        archive.addPackages(true, new String[]{"org.jbpm"});
        for (String targetPath : targetFileMap.keySet()) {
            archive.addAsResource((String)targetFileMap.get(targetPath), ArchivePaths.create((String)targetPath));
        }
        File testPackage = new File(packageTargetDir, fileName);
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(testPackage, true);
        return testPackage;
    }

    private ArrayList<String> resolveH2JarsForClassPath() {
        MavenDependencyResolver h2Resolver = ((MavenDependencyResolver)DependencyResolvers.use(MavenDependencyResolver.class)).loadMetadataFromPom("pom.xml");
        h2Resolver.artifact("com.h2database:h2");
        ArrayList<String> classPathList = new ArrayList<String>();
        File[] h2Files = h2Resolver.resolveAsFiles();
        for (int f = 0; f < h2Files.length; ++f) {
            classPathList.add(h2Files[f].getAbsolutePath());
        }
        return classPathList;
    }
}

