/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dependencies.hib4;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jbpm.dependencies.hib4.Hibernate4PackagingTest;
import org.junit.Ignore;
import org.junit.Test;

public class Hib4OraclePackagingTest
extends Hibernate4PackagingTest {
    @Test
    @Ignore
    public void test() throws Exception {
        File humanTaskJar = this.buildOracleJpa2Hiberate4Jar();
        ProcessBuilder procBldr = Hib4OraclePackagingTest.buildProcessBuilder(humanTaskJar.getAbsolutePath(), this.resolveOracleJarsForClassPath());
        Process testProcess = procBldr.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(testProcess.getInputStream()));
        String line = null;
        while ((line = in.readLine()) != null) {
            System.out.println(line);
        }
        int exitValue = testProcess.waitFor();
        if (exitValue != 0) {
            Assert.fail((String)("Tests did not succeed [ exit == " + exitValue + "]"));
        }
    }

    private File buildOracleJpa2Hiberate4Jar() throws IOException {
        String fileName = "h2Hib4.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)fileName);
        HashMap<String, String> targetFileMap = new HashMap<String, String>();
        targetFileMap.put("META-INF/persistence.xml", "package/jpa2/oracle/persistence.xml");
        targetFileMap.put("datasource.properties", "package/jpa2/oracle/datasource.properties");
        targetFileMap.put("META-INF/Taskorm-JPA2.xml", "package/jpa2/Taskorm-JPA2.xml");
        targetFileMap.put("log4j.xml", "package/hib4/log4j.xml");
        targetFileMap.put("jbpm.usergroup.callback.properties", "jbpm.usergroup.callback.properties");
        Set<String> mvelFiles = Hib4OraclePackagingTest.getMvelFilePaths();
        for (String mvelFile : mvelFiles) {
            targetFileMap.put(mvelFile, mvelFile);
        }
        archive.addPackages(true, new String[]{"org.jbpm"});
        for (String targetPath : targetFileMap.keySet()) {
            archive.addAsResource((String)targetFileMap.get(targetPath), ArchivePaths.create((String)targetPath));
        }
        File testPackage = new File(packageTargetDir, fileName);
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(testPackage, true);
        return testPackage;
    }

    private ArrayList<String> resolveOracleJarsForClassPath() {
        String oracleDriverPath = System.getProperty("oracle.jdbc.path");
        if (oracleDriverPath == null) {
            throw new IllegalArgumentException("Oracle driver is not provided, please specify it via system property: oracle.jdbc.path");
        }
        ArrayList<String> classPathList = new ArrayList<String>();
        File[] h2Files = new File[]{new File(oracleDriverPath)};
        for (int f = 0; f < h2Files.length; ++f) {
            classPathList.add(h2Files[f].getAbsolutePath());
        }
        return classPathList;
    }
}

