/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.process.workitem.wsht.MyObject;
import org.jbpm.task.AccessType;
import org.jbpm.task.BaseTestNoUserGroupSetup;
import org.jbpm.task.I18NText;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.PermissionDeniedException;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;

public abstract class WSHumanTaskHandlerBaseUserGroupCallbackTest
extends BaseTestNoUserGroupSetup {
    private static final int DEFAULT_WAIT_TIME = 5000;
    private static final int MANAGER_COMPLETION_WAIT_TIME = 5000;
    private static final int MANAGER_ABORT_WAIT_TIME = 5000;
    private TaskClient client;
    private WorkItemHandler handler;

    public void setClient(TaskClient client) {
        this.client = client;
    }

    public TaskClient getClient() {
        return this.client;
    }

    public void testTaskGroupActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", groupIds, "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"TaskName", (String)taskSummary.getName());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)10, (int)taskSummary.getPriority());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Ready, (Object)taskSummary.getStatus());
        logger.debug("Claiming task " + taskSummary.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().claim(taskSummary.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        PermissionDeniedException denied = null;
        try {
            operationResponseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        logger.debug("Claimed task " + taskSummary.getId());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(taskSummary.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
    }

    public void testTaskFail() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        logger.debug("Starting task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Started task " + task.getId());
        logger.debug("Failing task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().fail(task.getId(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Failed task " + task.getId());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertTrue((boolean)manager.waitTillAborted(5000L));
    }

    public void testTaskSkip() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        logger.debug("Skipping task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().skip(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Skipped task " + task.getId());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertTrue((boolean)manager.waitTillAborted(5000L));
    }

    public void testTaskAbortSkippable() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        this.getHandler().abortWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testTaskAbortNotSkippable() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("Skippable", (Object)"false");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)1, (int)tasks.size());
        this.getHandler().abortWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testTaskExit() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().exit(task.getId(), "Administrator", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(task.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task taskInstance = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"TaskName", (String)((I18NText)taskInstance.getNames().get(0)).getText());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Exited, (Object)taskInstance.getTaskData().getStatus());
    }

    public void testTaskData() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("Content", (Object)"This is the content");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"TaskName", (String)taskSummary.getName());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)10, (int)taskSummary.getPriority());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Reserved, (Object)taskSummary.getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Darth Vader", (String)taskSummary.getActualOwner().getId());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(taskSummary.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)AccessType.Inline, (Object)task.getTaskData().getDocumentAccessType());
        long contentId = task.getTaskData().getDocumentContentId();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        this.getClient().getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        ByteArrayInputStream bis = new ByteArrayInputStream(getContentResponseHandler.getContent().getContent());
        ObjectInputStream in = new ObjectInputStream(bis);
        Object data = in.readObject();
        in.close();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)"This is the content", (Object)data);
        logger.debug("Starting task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(task.getId().longValue(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Started task " + task.getId());
        logger.debug("Completing task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        ContentData result = new ContentData();
        result.setAccessType(AccessType.Inline);
        result.setType("java.lang.String");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject("This is the result");
        out.close();
        result.setContent(bos.toByteArray());
        this.getClient().complete(task.getId().longValue(), "Darth Vader", result, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Completed task " + task.getId());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
        Map<String, Object> results = manager.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertNotNull(results);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)"Darth Vader", (Object)results.get("ActorId"));
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)"This is the result", (Object)results.get("Result"));
    }

    public void testTaskDataAutomaticMapping() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        MyObject myObject = new MyObject("MyObjectValue");
        workItem.setParameter("MyObject", (Object)myObject);
        HashMap<String, MyObject> mapParameter = new HashMap<String, MyObject>();
        mapParameter.put("MyObjectInsideTheMap", myObject);
        workItem.setParameter("MyMap", mapParameter);
        workItem.setParameter("MyObject", (Object)myObject);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"TaskName", (String)taskSummary.getName());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)10, (int)taskSummary.getPriority());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Reserved, (Object)taskSummary.getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Darth Vader", (String)taskSummary.getActualOwner().getId());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(taskSummary.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)AccessType.Inline, (Object)task.getTaskData().getDocumentAccessType());
        long contentId = task.getTaskData().getDocumentContentId();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        this.getClient().getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        ByteArrayInputStream bis = new ByteArrayInputStream(getContentResponseHandler.getContent().getContent());
        ObjectInputStream in = new ObjectInputStream(bis);
        Map data = (Map)in.readObject();
        in.close();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"MyObjectValue", (String)((MyObject)data.get("MyObject")).getValue());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)"10", data.get("Priority"));
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"MyObjectValue", (String)((MyObject)((Map)data.get("MyMap")).get("MyObjectInsideTheMap")).getValue());
        logger.debug("Starting task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(task.getId().longValue(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Started task " + task.getId());
        logger.debug("Completing task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        ContentData result = new ContentData();
        result.setAccessType(AccessType.Inline);
        result.setType("java.lang.String");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject("This is the result");
        out.close();
        result.setContent(bos.toByteArray());
        this.getClient().complete(task.getId().longValue(), "Darth Vader", result, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Completed task " + task.getId());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
        Map<String, Object> results = manager.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertNotNull(results);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)"Darth Vader", (Object)results.get("ActorId"));
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)"This is the result", (Object)results.get("Result"));
    }

    public void TODOtestOnAllSubTasksEndParentEndStrategy() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameParent");
        workItem.setParameter("Comment", (Object)"CommentParent");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("SubTaskStrategies", (Object)"OnAllSubTasksEndParentEnd");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"TaskNameParent", (String)task.getName());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"CommentParent", (String)task.getDescription());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameChild1");
        workItem.setParameter("Comment", (Object)"CommentChild1");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task2");
        workItem.setParameter("TaskName", (Object)"TaskNameChild2");
        workItem.setParameter("Comment", (Object)"CommentChild2");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        logger.debug("Starting task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Started task " + task.getId());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(task.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task parentTask = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.InProgress, (Object)parentTask.getTaskData().getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals(this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getSubTasksAssignedAsPotentialOwner(parentTask.getId().longValue(), "Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List subTasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)2, (int)subTasks.size());
        TaskSummary subTaskSummary1 = (TaskSummary)subTasks.get(0);
        TaskSummary subTaskSummary2 = (TaskSummary)subTasks.get(1);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertNotNull((Object)subTaskSummary1);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertNotNull((Object)subTaskSummary2);
        logger.debug("Starting sub task " + subTaskSummary1.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(subTaskSummary1.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Started sub task " + subTaskSummary1.getId());
        logger.debug("Starting sub task " + subTaskSummary2.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(subTaskSummary2.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Started sub task " + subTaskSummary2.getId());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTaskSummary1.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task subTask1 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.InProgress, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTaskSummary2.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task subTask2 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.InProgress, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        logger.debug("Completing sub task " + subTask1.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().complete(subTask1.getId().longValue(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Completed sub task " + subTask1.getId());
        logger.debug("Completing sub task " + subTask2.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().complete(subTask2.getId().longValue(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Completed sub task " + subTask2.getId());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTask1.getId().longValue(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        subTask1 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Completed, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTask2.getId().longValue(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        subTask2 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Completed, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(parentTask.getId().longValue(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        parentTask = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Completed, (Object)parentTask.getTaskData().getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals(this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    public void TODOtestOnParentAbortAllSubTasksEndStrategy() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameParent");
        workItem.setParameter("Comment", (Object)"CommentParent");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("SubTaskStrategies", (Object)"OnParentAbortAllSubTasksEnd");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"TaskNameParent", (String)task.getName());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"CommentParent", (String)task.getDescription());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameChild1");
        workItem.setParameter("Comment", (Object)"CommentChild1");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task2");
        workItem.setParameter("TaskName", (Object)"TaskNameChild2");
        workItem.setParameter("Comment", (Object)"CommentChild2");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        logger.debug("Starting task " + task.getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Started task " + task.getId());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(task.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task parentTask = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.InProgress, (Object)parentTask.getTaskData().getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals(this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getSubTasksAssignedAsPotentialOwner(parentTask.getId().longValue(), "Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List subTasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((int)2, (int)subTasks.size());
        TaskSummary subTaskSummary1 = (TaskSummary)subTasks.get(0);
        TaskSummary subTaskSummary2 = (TaskSummary)subTasks.get(1);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertNotNull((Object)subTaskSummary1);
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertNotNull((Object)subTaskSummary2);
        logger.debug("Starting sub task " + subTaskSummary1.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(subTaskSummary1.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Started sub task " + subTaskSummary1.getId());
        logger.debug("Starting sub task " + subTaskSummary2.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(subTaskSummary2.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Started sub task " + subTaskSummary2.getId());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTaskSummary1.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task subTask1 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.InProgress, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTaskSummary2.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task subTask2 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.InProgress, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        logger.debug("Completing parent task " + parentTask.getId());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().skip(parentTask.getId().longValue(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        logger.debug("Completed parent task " + parentTask.getId());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTaskSummary1.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        subTask1 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Completed, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTaskSummary2.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        subTask2 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals((Object)Status.Completed, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        WSHumanTaskHandlerBaseUserGroupCallbackTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    public void setHandler(WorkItemHandler handler) {
        this.handler = handler;
    }

    public WorkItemHandler getHandler() {
        return this.handler;
    }

    private class TestWorkItemManager
    implements WorkItemManager {
        private volatile boolean completed;
        private volatile boolean aborted;
        private volatile Map<String, Object> results;

        private TestWorkItemManager() {
        }

        public synchronized boolean waitTillCompleted(long time) {
            if (!this.isCompleted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isCompleted();
        }

        public synchronized boolean waitTillAborted(long time) {
            if (!this.isAborted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isAborted();
        }

        public void abortWorkItem(long id) {
            this.setAborted(true);
        }

        public synchronized boolean isAborted() {
            return this.aborted;
        }

        private synchronized void setAborted(boolean aborted) {
            this.aborted = aborted;
            this.notifyAll();
        }

        public void completeWorkItem(long id, Map<String, Object> results) {
            this.results = results;
            this.setCompleted(true);
        }

        private synchronized void setCompleted(boolean completed) {
            this.completed = completed;
            this.notifyAll();
        }

        public synchronized boolean isCompleted() {
            return this.completed;
        }

        public Map<String, Object> getResults() {
            return this.results;
        }

        public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        }
    }
}

