/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht;

import java.util.List;
import java.util.Map;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.process.workitem.wsht.SyncWSHumanTaskHandler;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Status;
import org.jbpm.task.TaskService;
import org.jbpm.task.TestStatefulKnowledgeSession;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.local.LocalTaskService;

public class WSHumanTaskMultipleHandlersLocalSyncTest
extends BaseTest {
    protected TestStatefulKnowledgeSession ksession = new TestStatefulKnowledgeSession();
    private TaskService client = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        super.tearDown();
    }

    public void testLocalMultipleHandlers() throws Exception {
        this.client = new LocalTaskService(this.taskService);
        SyncWSHumanTaskHandler handler = new SyncWSHumanTaskHandler(this.client, (KnowledgeRuntime)this.ksession);
        handler.setLocal(true);
        handler.connect();
        SingleCallbackWorkItemManager manager = new SingleCallbackWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((long)10L, (long)task.getProcessInstanceId());
        this.client.start(task.getId(), "Darth Vader");
        handler.dispose();
        this.client = new LocalTaskService(this.taskService);
        SyncWSHumanTaskHandler handler2 = new SyncWSHumanTaskHandler(this.client, (KnowledgeRuntime)this.ksession);
        handler2.setLocal(true);
        handler2.connect();
        this.client.complete(task.getId(), "Darth Vader", null);
        handler2.dispose();
        this.client.disconnect();
        WSHumanTaskMultipleHandlersLocalSyncTest.assertFalse((String)"work item manager has errors (was completed/aborted more than once)", (boolean)manager.isError());
    }

    public void testSyncMultipleHandlers() throws Exception {
        this.client = new LocalTaskService(this.taskService);
        SyncWSHumanTaskHandler handler = new SyncWSHumanTaskHandler(this.client, (KnowledgeRuntime)this.ksession);
        handler.connect();
        SingleCallbackWorkItemManager manager = new SingleCallbackWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        WSHumanTaskMultipleHandlersLocalSyncTest.assertEquals((long)10L, (long)task.getProcessInstanceId());
        this.client.start(task.getId(), "Darth Vader");
        handler.dispose();
        this.client = new LocalTaskService(this.taskService);
        SyncWSHumanTaskHandler handler2 = new SyncWSHumanTaskHandler(this.client, (KnowledgeRuntime)this.ksession);
        handler2.connect();
        this.client.complete(task.getId(), "Darth Vader", null);
        handler2.dispose();
        this.client.disconnect();
        Thread.sleep(1000L);
        WSHumanTaskMultipleHandlersLocalSyncTest.assertFalse((String)"work item manager has errors (was completed/aborted more than once)", (boolean)manager.isError());
    }

    private class SingleCallbackWorkItemManager
    implements WorkItemManager {
        private volatile boolean completed;
        private volatile boolean aborted;
        private volatile boolean error;
        private volatile Map<String, Object> results;

        private SingleCallbackWorkItemManager() {
        }

        public synchronized boolean waitTillCompleted(long time) {
            if (!this.isCompleted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isCompleted();
        }

        public synchronized boolean waitTillAborted(long time) {
            if (!this.isAborted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isAborted();
        }

        public void abortWorkItem(long id) {
            if (this.aborted || this.completed) {
                this.error = true;
                throw new RuntimeException("work item manager has errors (was completed/aborted more than once)");
            }
            this.setAborted(true);
        }

        public synchronized boolean isAborted() {
            return this.aborted;
        }

        private synchronized void setAborted(boolean aborted) {
            this.aborted = aborted;
            this.notifyAll();
        }

        public void completeWorkItem(long id, Map<String, Object> results) {
            if (this.aborted || this.completed) {
                this.error = true;
                throw new RuntimeException("work item manager has errors (was completed/aborted more than once)");
            }
            this.results = results;
            this.setCompleted(true);
        }

        private synchronized void setCompleted(boolean completed) {
            this.completed = completed;
            this.notifyAll();
        }

        public synchronized boolean isCompleted() {
            return this.completed;
        }

        public Map<String, Object> getResults() {
            return this.results;
        }

        public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        }

        public boolean isError() {
            return this.error;
        }

        public void setError(boolean error) {
            this.error = error;
        }
    }
}

