/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.admin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.SystemEventListenerFactory;
import org.jbpm.task.Group;
import org.jbpm.task.I18NText;
import org.jbpm.task.MockUserInfo;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.admin.TasksAdmin;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.UserGroupCallbackManager;
import org.jbpm.task.service.local.LocalTaskService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TasksAdminTest {
    private EntityManagerFactory emf;
    private TaskServiceSession taskSession;
    private TaskService taskService;
    private Map<String, User> users = new HashMap<String, User>();
    private Map<String, Group> groups = new HashMap<String, Group>();

    @Before
    public void setUp() {
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.task");
        this.taskService = new TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener());
        this.taskSession = this.taskService.createSession();
        TasksAdminTest.addUsersAndGroups(this.taskSession, this.users, this.groups);
        MockUserInfo userInfo = new MockUserInfo();
        this.taskService.setUserinfo((UserInfo)userInfo);
        UserGroupCallbackManager.getInstance().setCallback(null);
    }

    @After
    public void tearDown() {
        this.taskSession.dispose();
        this.emf.close();
    }

    @Test
    public void completedTasksTest() {
        TasksAdminTest.runCompletedTasksTest(this.users, this.taskService);
    }

    public static void runCompletedTasksTest(Map<String, User> users, TaskService taskService) {
        LocalTaskService localTaskService = new LocalTaskService(taskService);
        Task task = TasksAdminTest.createSimpleTask(users.get("salaboy"), users.get("administrator"));
        localTaskService.addTask(task, new ContentData());
        Task simpleTask = localTaskService.getTaskByWorkItemId(1L);
        localTaskService.start(simpleTask.getId().longValue(), "salaboy");
        TasksAdmin admin = taskService.createTaskAdmin();
        List completedTasks = admin.getCompletedTasks();
        Assert.assertEquals((long)0L, (long)completedTasks.size());
        localTaskService.complete(simpleTask.getId().longValue(), "salaboy", null);
        completedTasks = admin.getCompletedTasks();
        Assert.assertEquals((long)1L, (long)completedTasks.size());
    }

    @Test
    public void completedSinceTasksTest() {
        TasksAdminTest.runCompletedSinceTasksTest(this.users, this.taskService);
    }

    public static void runCompletedSinceTasksTest(Map<String, User> users, TaskService taskService) {
        LocalTaskService localTaskService = new LocalTaskService(taskService);
        Task task = TasksAdminTest.createSimpleTask(users.get("salaboy"), users.get("administrator"));
        localTaskService.addTask(task, new ContentData());
        List salaboysTasks = localTaskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        TaskSummary simpleTask = (TaskSummary)salaboysTasks.get(0);
        localTaskService.start(simpleTask.getId(), "salaboy");
        TasksAdmin admin = taskService.createTaskAdmin();
        List completedTasks = admin.getCompletedTasks(new Date());
        Assert.assertEquals((long)0L, (long)completedTasks.size());
        localTaskService.complete(simpleTask.getId(), "salaboy", null);
        completedTasks = admin.getCompletedTasks(new Date());
        Assert.assertEquals((long)1L, (long)completedTasks.size());
    }

    @Test
    public void archiveTasksTest() {
        TasksAdminTest.runArchiveTasksTest(this.users, this.taskService, this.emf);
    }

    public static void runArchiveTasksTest(Map<String, User> users, TaskService taskService, EntityManagerFactory emf) {
        LocalTaskService localTaskService = new LocalTaskService(taskService);
        Task task = TasksAdminTest.createSimpleTask(users.get("salaboy"), users.get("administrator"));
        localTaskService.addTask(task, new ContentData());
        List salaboysTasks = localTaskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        TaskSummary simpleTask = (TaskSummary)salaboysTasks.get(0);
        localTaskService.start(simpleTask.getId(), "salaboy");
        TasksAdmin admin = taskService.createTaskAdmin();
        int archived = admin.archiveTasks(admin.getActiveTasks());
        Assert.assertEquals((long)1L, (long)archived);
        List archivedTasks = admin.getArchivedTasks();
        Assert.assertEquals((long)1L, (long)archivedTasks.size());
        System.out.println(">>> Archived? " + localTaskService.getTask(((TaskSummary)archivedTasks.get(0)).getId()).isArchived());
        EntityManager em = emf.createEntityManager();
        System.out.println(">>> Archived? " + ((Task)em.find(Task.class, (Object)((TaskSummary)archivedTasks.get(0)).getId())).isArchived());
    }

    @Test
    public void removeTasksTest() {
        TasksAdminTest.runRemoveTasksTest(this.users, this.taskService, this.emf);
    }

    public static void runRemoveTasksTest(Map<String, User> users, TaskService taskService, EntityManagerFactory emf) {
        LocalTaskService localTaskService = new LocalTaskService(taskService);
        Task task = TasksAdminTest.createSimpleTask(users.get("salaboy"), users.get("administrator"));
        localTaskService.addTask(task, new ContentData());
        List salaboysTasks = localTaskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        TaskSummary simpleTask = (TaskSummary)salaboysTasks.get(0);
        localTaskService.start(simpleTask.getId(), "salaboy");
        TasksAdmin admin = taskService.createTaskAdmin();
        List activeTasks = admin.getActiveTasks();
        Task activeTask = localTaskService.getTask(((TaskSummary)activeTasks.get(0)).getId());
        int removed = admin.removeTasks(activeTasks);
        Assert.assertEquals((long)0L, (long)removed);
        int archived = admin.archiveTasks(activeTasks);
        Assert.assertEquals((long)1L, (long)archived);
        removed = admin.removeTasks(activeTasks);
        Assert.assertEquals((long)1L, (long)removed);
        EntityManager em = emf.createEntityManager();
        Assert.assertNull((Object)em.find(Task.class, (Object)activeTask.getId()));
    }

    public static void addUsersAndGroups(TaskServiceSession taskSession, Map<String, User> users, Map<String, Group> groups) {
        User user = new User("salaboy");
        taskSession.addUser(user);
        User administrator = new User("Administrator");
        taskSession.addUser(administrator);
        users.put("salaboy", user);
        users.put("administrator", administrator);
        Group myGroup = new Group("group1");
        taskSession.addGroup(myGroup);
        groups.put("group1", myGroup);
    }

    private static Task createSimpleTask(User user, User administrator) {
        Task task = new Task();
        task.setPriority(1);
        PeopleAssignments peopleAssignments = new PeopleAssignments();
        ArrayList<User> adminsEntities = new ArrayList<User>();
        adminsEntities.add(administrator);
        peopleAssignments.setBusinessAdministrators(adminsEntities);
        ArrayList<User> usersEntities = new ArrayList<User>();
        usersEntities.add(user);
        peopleAssignments.setPotentialOwners(usersEntities);
        peopleAssignments.setTaskInitiator(user);
        task.setPeopleAssignments(peopleAssignments);
        ArrayList<I18NText> names = new ArrayList<I18NText>();
        names.add(new I18NText("en-UK", "My Simple Task"));
        task.setNames(names);
        task.setDescriptions(names);
        task.setSubjects(names);
        TaskData data = new TaskData();
        data.setActualOwner(user);
        data.setCreatedBy(user);
        data.setWorkItemId(1L);
        data.setProcessInstanceId(1L);
        data.setProcessSessionId(1);
        task.setTaskData(data);
        return task;
    }
}

