/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Group;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.event.TaskCompletedEvent;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingEventResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;

public abstract class TaskLifeCycleBaseTest
extends BaseTest {
    protected TaskServer server;
    protected TaskClient client;

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        super.tearDown();
    }

    public void testLifeCycle() throws Exception {
        TaskLifeCycleBaseTest.runTestLifeCycle(this.client, this.users, this.groups);
    }

    public static void runTestLifeCycle(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskLifeCycleBaseTest.fillVariables(users, groups);
        BlockingTaskSummaryResponseHandler taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        int initialNumTasks = taskSummaryResponseHandler.getResults().size();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { workItemId = 1 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba']], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, taskId);
        BlockingEventResponseHandler handler = new BlockingEventResponseHandler();
        client.registerForEvent((EventKey)key, true, (EventResponseHandler)handler);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        List tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleBaseTest.assertEquals((int)(initialNumTasks + 1), (int)tasks.size());
        TaskLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)((TaskSummary)tasks.get(tasks.size() - 1)).getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleBaseTest.assertEquals((int)(initialNumTasks + 1), (int)tasks.size());
        TaskLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)((TaskSummary)tasks.get(tasks.size() - 1)).getStatus());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.complete(taskId, users.get("bobba").getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(1000L);
        Date completedBy = new Date();
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleBaseTest.assertEquals((int)initialNumTasks, (int)tasks.size());
        Payload payload = handler.getPayload();
        TaskCompletedEvent event = (TaskCompletedEvent)payload.get();
        TaskLifeCycleBaseTest.assertNotNull((Object)event);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskLifeCycleBaseTest.assertEquals((Object)Status.Completed, (Object)task1.getTaskData().getStatus());
        Date completedOn = task1.getTaskData().getCompletedOn();
        TaskLifeCycleBaseTest.assertTrue((String)"Completed on date was empty!", (completedOn != null ? 1 : 0) != 0);
        TaskLifeCycleBaseTest.assertTrue((String)"Completed on date is incorrect.", (boolean)completedBy.after(completedOn));
    }

    public void testLifeCycleMultipleTasks() throws Exception {
        TaskLifeCycleBaseTest.runTestLifeCycleMultipleTasks(this.client, this.users, this.groups);
    }

    public static void runTestLifeCycleMultipleTasks(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskLifeCycleBaseTest.fillVariables(users, groups);
        BlockingTaskSummaryResponseHandler taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        int initialNumTasks = taskSummaryResponseHandler.getResults().size();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { workItemId = 1 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba']], }),";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my description')], ";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my subject')], ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, taskId);
        BlockingEventResponseHandler handler = new BlockingEventResponseHandler();
        client.registerForEvent((EventKey)key, true, (EventResponseHandler)handler);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        List tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleBaseTest.assertEquals((int)(initialNumTasks + 1), (int)tasks.size());
        TaskLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)((TaskSummary)tasks.get(tasks.size() - 1)).getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleBaseTest.assertEquals((int)(initialNumTasks + 1), (int)tasks.size());
        TaskLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)((TaskSummary)tasks.get(tasks.size() - 1)).getStatus());
        BlockingAddTaskResponseHandler addTaskResponseHandler2 = new BlockingAddTaskResponseHandler();
        Task task2 = (Task)TaskLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task2, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler2);
        long taskId2 = addTaskResponseHandler.getTaskId();
        TaskEventKey key2 = new TaskEventKey(TaskCompletedEvent.class, taskId2);
        BlockingEventResponseHandler handler2 = new BlockingEventResponseHandler();
        client.registerForEvent((EventKey)key2, true, (EventResponseHandler)handler2);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleBaseTest.assertEquals((int)(initialNumTasks + 2), (int)tasks.size());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.complete(taskId, users.get("bobba").getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId2, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleBaseTest.assertEquals((int)(initialNumTasks + 1), (int)tasks.size());
        Payload payload = handler.getPayload();
        TaskCompletedEvent event = (TaskCompletedEvent)payload.get();
        TaskLifeCycleBaseTest.assertNotNull((Object)event);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task = getTaskResponseHandler.getTask();
        TaskLifeCycleBaseTest.assertEquals((Object)Status.Completed, (Object)task.getTaskData().getStatus());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.complete(taskId2, users.get("bobba").getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        payload = handler.getPayload();
        event = (TaskCompletedEvent)payload.get();
        TaskLifeCycleBaseTest.assertNotNull((Object)event);
        BlockingGetTaskResponseHandler getTaskResponseHandler2 = new BlockingGetTaskResponseHandler();
        client.getTask(taskId2, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler2);
        task2 = getTaskResponseHandler2.getTask();
        TaskLifeCycleBaseTest.assertEquals((Object)Status.Completed, (Object)task2.getTaskData().getStatus());
    }
}

