/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.StringReader;
import java.util.Map;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.task.BaseTestNoUserGroupSetup;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.event.TaskClaimedEvent;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.TaskUserEvent;
import org.jbpm.task.service.Operation;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingEventResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;

public abstract class TaskServiceEventMessagingBaseUserGroupCallbackTest
extends BaseTestNoUserGroupSetup {
    protected TaskServer server;
    protected TaskClient client;

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        super.tearDown();
    }

    public void testClaimEvent() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], businessAdministrators = [ users['darth'] ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceEventMessagingBaseUserGroupCallbackTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceEventMessagingBaseUserGroupCallbackTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        TaskEventKey key = new TaskEventKey(TaskClaimedEvent.class, taskId);
        BlockingEventResponseHandler handler = new BlockingEventResponseHandler();
        this.client.registerForEvent((EventKey)key, true, (EventResponseHandler)handler);
        Thread.sleep(3000L);
        this.taskSession.taskOperation(Operation.Claim, taskId, ((User)this.users.get("darth")).getId(), null, null, null);
        handler.waitTillDone(5000L);
        Payload payload = handler.getPayload();
        TaskUserEvent event = (TaskUserEvent)payload.get();
        TaskServiceEventMessagingBaseUserGroupCallbackTest.assertNotNull((Object)event);
    }
}

