/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Map;
import org.jbpm.task.AccessType;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;

public abstract class TaskServiceTaskAttributesBaseTest
extends BaseTest {
    protected TaskServer server;
    protected TaskClient client;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        super.tearDown();
    }

    public void testAddRemoveOutput() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now,";
        str = str + "actualOwner = new User('Darth Vader')}),";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = new PeopleAssignments(),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceTaskAttributesBaseTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        ContentData outputData = new ContentData();
        outputData.setAccessType(AccessType.Inline);
        outputData.setContent("This is my output!!!!".getBytes());
        outputData.setType("text/plain");
        BlockingTaskOperationResponseHandler setOutputResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.setOutput(taskId, "Darth Vader", outputData, (TaskClientHandler.TaskOperationResponseHandler)setOutputResponseHandler);
        setOutputResponseHandler.waitTillDone(1000L);
        TaskServiceTaskAttributesBaseTest.assertFalse((boolean)setOutputResponseHandler.hasError());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceTaskAttributesBaseTest.assertNotSame((Object)task, (Object)task1);
        TaskServiceTaskAttributesBaseTest.assertFalse((boolean)task.equals((Object)task1));
        long outputContentId = task1.getTaskData().getOutputContentId();
        TaskServiceTaskAttributesBaseTest.assertNotSame((Object)0, (Object)outputContentId);
        BlockingGetContentResponseHandler getOutputResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(outputContentId, (TaskClientHandler.GetContentResponseHandler)getOutputResponseHandler);
        TaskServiceTaskAttributesBaseTest.assertNotNull((Object)getOutputResponseHandler.getContent());
        Content content = getOutputResponseHandler.getContent();
        TaskServiceTaskAttributesBaseTest.assertEquals((String)"This is my output!!!!", (String)new String(content.getContent()));
        TaskServiceTaskAttributesBaseTest.assertEquals((String)"text/plain", (String)task1.getTaskData().getOutputType());
        TaskServiceTaskAttributesBaseTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getOutputAccessType());
        TaskServiceTaskAttributesBaseTest.assertEquals((long)outputContentId, (long)content.getId());
        task.getTaskData().setOutput(outputContentId, outputData);
        task.getTaskData().setStatus(Status.Created);
        TaskServiceTaskAttributesBaseTest.assertEquals((Object)task, (Object)task1);
        BlockingTaskOperationResponseHandler deleteOutputResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.deleteOutput(taskId, "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)deleteOutputResponseHandler);
        deleteOutputResponseHandler.waitTillDone(1000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        TaskServiceTaskAttributesBaseTest.assertEquals((long)0L, (long)task1.getTaskData().getOutputContentId());
        TaskServiceTaskAttributesBaseTest.assertNull((Object)task1.getTaskData().getOutputAccessType());
        TaskServiceTaskAttributesBaseTest.assertNull((Object)task1.getTaskData().getOutputType());
    }

    public void testAddRemoveFault() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now,";
        str = str + "actualOwner = new User('Darth Vader')}),";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = new PeopleAssignments(),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceTaskAttributesBaseTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        FaultData faultData = new FaultData();
        faultData.setAccessType(AccessType.Inline);
        faultData.setContent("This is my fault!!!!".getBytes());
        faultData.setFaultName("fault1");
        faultData.setType("text/plain");
        BlockingTaskOperationResponseHandler setFaultResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.setFault(taskId, "Darth Vader", faultData, (TaskClientHandler.TaskOperationResponseHandler)setFaultResponseHandler);
        setFaultResponseHandler.waitTillDone(1000L);
        TaskServiceTaskAttributesBaseTest.assertFalse((boolean)setFaultResponseHandler.hasError());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceTaskAttributesBaseTest.assertNotSame((Object)task, (Object)task1);
        TaskServiceTaskAttributesBaseTest.assertFalse((boolean)task.equals((Object)task1));
        long faultContentId = task1.getTaskData().getFaultContentId();
        TaskServiceTaskAttributesBaseTest.assertNotSame((Object)0, (Object)faultContentId);
        BlockingGetContentResponseHandler getFaultResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(faultContentId, (TaskClientHandler.GetContentResponseHandler)getFaultResponseHandler);
        TaskServiceTaskAttributesBaseTest.assertNotNull((Object)getFaultResponseHandler.getContent());
        Content content = getFaultResponseHandler.getContent();
        TaskServiceTaskAttributesBaseTest.assertEquals((String)"This is my fault!!!!", (String)new String(content.getContent()));
        TaskServiceTaskAttributesBaseTest.assertEquals((String)"text/plain", (String)task1.getTaskData().getFaultType());
        TaskServiceTaskAttributesBaseTest.assertEquals((String)"fault1", (String)task1.getTaskData().getFaultName());
        TaskServiceTaskAttributesBaseTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getFaultAccessType());
        TaskServiceTaskAttributesBaseTest.assertEquals((long)faultContentId, (long)content.getId());
        task.getTaskData().setOutput(faultContentId, (ContentData)faultData);
        task.getTaskData().setStatus(Status.Created);
        TaskServiceTaskAttributesBaseTest.assertEquals((Object)task, (Object)task1);
        BlockingTaskOperationResponseHandler deleteFaultResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.deleteFault(taskId, "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)deleteFaultResponseHandler);
        deleteFaultResponseHandler.waitTillDone(1000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        TaskServiceTaskAttributesBaseTest.assertEquals((long)0L, (long)task1.getTaskData().getFaultContentId());
        TaskServiceTaskAttributesBaseTest.assertNull((Object)task1.getTaskData().getFaultAccessType());
        TaskServiceTaskAttributesBaseTest.assertNull((Object)task1.getTaskData().getFaultType());
        TaskServiceTaskAttributesBaseTest.assertNull((Object)task1.getTaskData().getFaultName());
    }

    public void testSetPriority() throws Exception {
        TaskServiceTaskAttributesBaseTest.testSetPriority(this.fillVariables(), this.client);
    }

    public static void testSetPriority(Map vars, Object client) throws Exception {
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now,";
        str = str + "actualOwner = new User('Darth Vader')}),";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['darth'] ]}),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskService.eval((Reader)new StringReader(str), (Map)vars);
        try {
            Method addTaskMethod = TaskServiceTaskAttributesBaseTest.getMethod(client, "addTask");
            addTaskMethod.invoke(client, task, null, addTaskResponseHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            TaskServiceTaskAttributesBaseTest.fail((String)e.getMessage());
        }
        long taskId = addTaskResponseHandler.getTaskId();
        int newPriority = 33;
        BlockingTaskOperationResponseHandler setPriorityResponseHandler = new BlockingTaskOperationResponseHandler();
        try {
            Method setPriorityMethod = TaskServiceTaskAttributesBaseTest.getMethod(client, "setPriority");
            setPriorityMethod.invoke(client, taskId, "Darth Vader", newPriority, setPriorityResponseHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            TaskServiceTaskAttributesBaseTest.fail((String)e.getMessage());
        }
        setPriorityResponseHandler.waitTillDone(1000L);
        TaskServiceTaskAttributesBaseTest.assertFalse((boolean)setPriorityResponseHandler.hasError());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        try {
            Method getTaskMethod = TaskServiceTaskAttributesBaseTest.getMethod(client, "getTask");
            getTaskMethod.invoke(client, taskId, getTaskResponseHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            TaskServiceTaskAttributesBaseTest.fail((String)e.getMessage());
        }
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceTaskAttributesBaseTest.assertNotSame((Object)task, (Object)task1);
        TaskServiceTaskAttributesBaseTest.assertFalse((boolean)task.equals((Object)task1));
        int newPriority1 = task1.getPriority();
        TaskServiceTaskAttributesBaseTest.assertEquals((int)newPriority, (int)newPriority1);
        task.setPriority(newPriority);
        task.getTaskData().setStatus(Status.Created);
        TaskServiceTaskAttributesBaseTest.assertEquals((Object)task, (Object)task1);
    }

    private static Method getMethod(Object object, String methodName) {
        Method[] methods = object.getClass().getDeclaredMethods();
        Method methodFound = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            methodFound = methods[i];
            break;
        }
        return methodFound;
    }
}

