/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.async;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.drools.process.instance.impl.DefaultWorkItemManager;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Content;
import org.jbpm.task.MockUserInfo;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.service.DefaultEscalatedDeadlineHandler;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingSetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public abstract class TaskServiceDeadlinesBaseAsyncTest
extends BaseTest {
    protected TaskServer server;
    protected AsyncTaskService client;
    private Properties conf;
    private Wiser wiser;

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        this.getWiser().stop();
        super.tearDown();
    }

    public void testDelayedEmailNotificationOnDeadline() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        DefaultEscalatedDeadlineHandler notificationHandler = new DefaultEscalatedDeadlineHandler(this.getConf());
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        notificationHandler.setManager((WorkItemManager)manager);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("darth"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("darth"), "en-UK");
        notificationHandler.setUserInfo((UserInfo)userInfo);
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)notificationHandler);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotification.mvel"));
        Task task = (Task)TaskServiceDeadlinesBaseAsyncTest.eval(reader, vars);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Content content = new Content();
        content.setContent("['subject' : 'My Subject', 'body' : 'My Body']".getBytes());
        BlockingSetContentResponseHandler setContentResponseHandler = new BlockingSetContentResponseHandler();
        this.client.setDocumentContent(taskId, content, (TaskClientHandler.SetDocumentResponseHandler)setContentResponseHandler);
        long contentId = setContentResponseHandler.getContentId();
        BlockingGetContentResponseHandler getResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getResponseHandler);
        content = getResponseHandler.getContent();
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((String)"['subject' : 'My Subject', 'body' : 'My Body']", (String)new String(content.getContent()));
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 15000L; time += 500L) {
            Thread.sleep(500L);
        }
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)2, (int)this.getWiser().getMessages().size());
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(((WiserMessage)this.getWiser().getMessages().get(0)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.getWiser().getMessages().get(1)).getEnvelopeReceiver());
        TaskServiceDeadlinesBaseAsyncTest.assertTrue((boolean)list.contains("tony@domain.com"));
        TaskServiceDeadlinesBaseAsyncTest.assertTrue((boolean)list.contains("darth@domain.com"));
        MimeMessage msg = ((WiserMessage)this.getWiser().getMessages().get(0)).getMimeMessage();
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((Object)"My Body", (Object)msg.getContent());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((String)"My Subject", (String)msg.getSubject());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((String)"from@domain.com", (String)((InternetAddress)msg.getFrom()[0]).getAddress());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((String)"replyTo@domain.com", (String)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((String)"darth@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[1]).getAddress());
    }

    public void testDelayedReassignmentOnDeadline() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        DefaultEscalatedDeadlineHandler notificationHandler = new DefaultEscalatedDeadlineHandler(this.getConf());
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        notificationHandler.setManager((WorkItemManager)manager);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("luke"), "luke@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("bobba"), "luke@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("jabba"), "luke@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("luke"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("bobba"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("jabba"), "en-UK");
        notificationHandler.setUserInfo((UserInfo)userInfo);
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)notificationHandler);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithReassignment.mvel"));
        Task task = (Task)TaskServiceDeadlinesBaseAsyncTest.eval(reader, vars);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Thread.sleep(1000L);
        BlockingGetTaskResponseHandler getTaskHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskHandler);
        task = getTaskHandler.getTask();
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ArrayList<String> ids = new ArrayList<String>(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        TaskServiceDeadlinesBaseAsyncTest.assertTrue((boolean)ids.contains(((User)this.users.get("tony")).getId()));
        TaskServiceDeadlinesBaseAsyncTest.assertTrue((boolean)ids.contains(((User)this.users.get("luke")).getId()));
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 15000L; time += 500L) {
            Thread.sleep(500L);
        }
        getTaskHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskHandler);
        task = getTaskHandler.getTask();
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        logger.debug(potentialOwners.toString());
        ids = new ArrayList(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        TaskServiceDeadlinesBaseAsyncTest.assertTrue((boolean)ids.contains(((User)this.users.get("bobba")).getId()));
        TaskServiceDeadlinesBaseAsyncTest.assertTrue((boolean)ids.contains(((User)this.users.get("jabba")).getId()));
    }

    public void testDelayedEmailNotificationOnDeadlineTaskCompleted() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        DefaultEscalatedDeadlineHandler notificationHandler = new DefaultEscalatedDeadlineHandler(this.getConf());
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        notificationHandler.setManager((WorkItemManager)manager);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("darth"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("darth"), "en-UK");
        notificationHandler.setUserInfo((UserInfo)userInfo);
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)notificationHandler);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotification.mvel"));
        Task task = (Task)TaskServiceDeadlinesBaseAsyncTest.eval(reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<User> ba = new ArrayList<User>();
        ba.add(new User("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<User> po = new ArrayList<User>();
        po.add(new User("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments(assignments);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Content content = new Content();
        String emailContent = "{body=My Body, subject=My Subject}";
        content.setContent(emailContent.getBytes());
        BlockingSetContentResponseHandler setContentResponseHandler = new BlockingSetContentResponseHandler();
        this.client.setDocumentContent(taskId, content, (TaskClientHandler.SetDocumentResponseHandler)setContentResponseHandler);
        long contentId = setContentResponseHandler.getContentId();
        BlockingGetContentResponseHandler getResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getResponseHandler);
        content = getResponseHandler.getContent();
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((String)emailContent, (String)new String(content.getContent()));
        BlockingTaskOperationResponseHandler startTaskResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, "Administrator", (TaskClientHandler.TaskOperationResponseHandler)startTaskResponseHandler);
        startTaskResponseHandler.waitTillDone(2000L);
        BlockingTaskOperationResponseHandler completeTaskResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId, "Administrator", null, (TaskClientHandler.TaskOperationResponseHandler)completeTaskResponseHandler);
        completeTaskResponseHandler.waitTillDone(2000L);
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 15000L; time += 500L) {
            Thread.sleep(500L);
        }
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        BlockingGetTaskResponseHandler getTaskHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskHandler);
        task = getTaskHandler.getTask();
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((Object)Status.Completed, (Object)task.getTaskData().getStatus());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)task.getDeadlines().getStartDeadlines().size());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)task.getDeadlines().getEndDeadlines().size());
    }

    public void testDelayedEmailNotificationOnDeadlineTaskFailed() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        DefaultEscalatedDeadlineHandler notificationHandler = new DefaultEscalatedDeadlineHandler(this.getConf());
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        notificationHandler.setManager((WorkItemManager)manager);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("darth"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("darth"), "en-UK");
        notificationHandler.setUserInfo((UserInfo)userInfo);
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)notificationHandler);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotification.mvel"));
        Task task = (Task)TaskServiceDeadlinesBaseAsyncTest.eval(reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<User> ba = new ArrayList<User>();
        ba.add(new User("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<User> po = new ArrayList<User>();
        po.add(new User("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments(assignments);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Content content = new Content();
        String emailContent = "{body=My Body, subject=My Subject}";
        content.setContent(emailContent.getBytes());
        BlockingSetContentResponseHandler setContentResponseHandler = new BlockingSetContentResponseHandler();
        this.client.setDocumentContent(taskId, content, (TaskClientHandler.SetDocumentResponseHandler)setContentResponseHandler);
        long contentId = setContentResponseHandler.getContentId();
        BlockingGetContentResponseHandler getResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getResponseHandler);
        content = getResponseHandler.getContent();
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((String)emailContent, (String)new String(content.getContent()));
        BlockingTaskOperationResponseHandler startTaskResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, "Administrator", (TaskClientHandler.TaskOperationResponseHandler)startTaskResponseHandler);
        startTaskResponseHandler.waitTillDone(2000L);
        BlockingTaskOperationResponseHandler failTaskResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.fail(taskId, "Administrator", null, (TaskClientHandler.TaskOperationResponseHandler)failTaskResponseHandler);
        failTaskResponseHandler.waitTillDone(2000L);
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 15000L; time += 500L) {
            Thread.sleep(500L);
        }
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        BlockingGetTaskResponseHandler getTaskHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskHandler);
        task = getTaskHandler.getTask();
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((Object)Status.Failed, (Object)task.getTaskData().getStatus());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)task.getDeadlines().getStartDeadlines().size());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)task.getDeadlines().getEndDeadlines().size());
    }

    public void testDelayedEmailNotificationOnDeadlineTaskSkipped() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        DefaultEscalatedDeadlineHandler notificationHandler = new DefaultEscalatedDeadlineHandler(this.getConf());
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        notificationHandler.setManager((WorkItemManager)manager);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("darth"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("darth"), "en-UK");
        notificationHandler.setUserInfo((UserInfo)userInfo);
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)notificationHandler);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotification.mvel"));
        Task task = (Task)TaskServiceDeadlinesBaseAsyncTest.eval(reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<User> ba = new ArrayList<User>();
        ba.add(new User("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<User> po = new ArrayList<User>();
        po.add(new User("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments(assignments);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Content content = new Content();
        String emailContent = "{body=My Body, subject=My Subject}";
        content.setContent(emailContent.getBytes());
        BlockingSetContentResponseHandler setContentResponseHandler = new BlockingSetContentResponseHandler();
        this.client.setDocumentContent(taskId, content, (TaskClientHandler.SetDocumentResponseHandler)setContentResponseHandler);
        long contentId = setContentResponseHandler.getContentId();
        BlockingGetContentResponseHandler getResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getResponseHandler);
        content = getResponseHandler.getContent();
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((String)emailContent, (String)new String(content.getContent()));
        BlockingTaskOperationResponseHandler skipTaskResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.skip(taskId, "Administrator", (TaskClientHandler.TaskOperationResponseHandler)skipTaskResponseHandler);
        skipTaskResponseHandler.waitTillDone(2000L);
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 15000L; time += 500L) {
            Thread.sleep(500L);
        }
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        BlockingGetTaskResponseHandler getTaskHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskHandler);
        task = getTaskHandler.getTask();
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((Object)Status.Obsolete, (Object)task.getTaskData().getStatus());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)task.getDeadlines().getStartDeadlines().size());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)task.getDeadlines().getEndDeadlines().size());
    }

    public void testDelayedEmailNotificationOnDeadlineTaskExited() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        DefaultEscalatedDeadlineHandler notificationHandler = new DefaultEscalatedDeadlineHandler(this.getConf());
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        notificationHandler.setManager((WorkItemManager)manager);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("darth"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("darth"), "en-UK");
        notificationHandler.setUserInfo((UserInfo)userInfo);
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)notificationHandler);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotification.mvel"));
        Task task = (Task)TaskServiceDeadlinesBaseAsyncTest.eval(reader, vars);
        task.getTaskData().setSkipable(true);
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<User> ba = new ArrayList<User>();
        ba.add(new User("Administrator"));
        assignments.setBusinessAdministrators(ba);
        ArrayList<User> po = new ArrayList<User>();
        po.add(new User("Administrator"));
        assignments.setPotentialOwners(po);
        task.setPeopleAssignments(assignments);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        Content content = new Content();
        String emailContent = "{body=My Body, subject=My Subject}";
        content.setContent(emailContent.getBytes());
        BlockingSetContentResponseHandler setContentResponseHandler = new BlockingSetContentResponseHandler();
        this.client.setDocumentContent(taskId, content, (TaskClientHandler.SetDocumentResponseHandler)setContentResponseHandler);
        long contentId = setContentResponseHandler.getContentId();
        BlockingGetContentResponseHandler getResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getResponseHandler);
        content = getResponseHandler.getContent();
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((String)emailContent, (String)new String(content.getContent()));
        BlockingTaskOperationResponseHandler exitTaskResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.exit(taskId, "Administrator", (TaskClientHandler.TaskOperationResponseHandler)exitTaskResponseHandler);
        exitTaskResponseHandler.waitTillDone(2000L);
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 15000L; time += 500L) {
            Thread.sleep(500L);
        }
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        BlockingGetTaskResponseHandler getTaskHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskHandler);
        task = getTaskHandler.getTask();
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)task.getDeadlines().getStartDeadlines().size());
        TaskServiceDeadlinesBaseAsyncTest.assertEquals((int)0, (int)task.getDeadlines().getEndDeadlines().size());
    }

    public void setConf(Properties conf) {
        this.conf = conf;
    }

    public Properties getConf() {
        return this.conf;
    }

    public void setWiser(Wiser wiser) {
        this.wiser = wiser;
    }

    public Wiser getWiser() {
        return this.wiser;
    }
}

