/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.async;

import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.drools.SystemEventListenerFactory;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Task;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.MockEscalatedDeadlineHandler;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;

public abstract class TaskServiceEscalationBaseAsyncTest
extends BaseTest {
    protected TaskServer server;
    protected AsyncTaskService client;

    public void testDummy() {
        TaskServiceEscalationBaseAsyncTest.assertTrue((boolean)true);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        super.tearDown();
    }

    public void testUnescalatedDeadlines() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        MockEscalatedDeadlineHandler handler = new MockEscalatedDeadlineHandler();
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)handler);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/QueryData_UnescalatedDeadlines.mvel"));
        List tasks = (List)TaskServiceEscalationBaseAsyncTest.eval(reader, vars);
        long now = ((Date)vars.get("now")).getTime();
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
            this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
            addTaskResponseHandler.waitTillDone(3000L);
        }
        TaskServiceEscalationBaseAsyncTest.testDeadlines(now, handler);
    }

    public void testUnescalatedDeadlinesOnStartup() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/QueryData_UnescalatedDeadlines.mvel"));
        List tasks = (List)TaskServiceEscalationBaseAsyncTest.eval(reader, vars);
        long now = ((Date)vars.get("now")).getTime();
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (Task task : tasks) {
            em.persist((Object)task);
        }
        em.getTransaction().commit();
        MockEscalatedDeadlineHandler handler = new MockEscalatedDeadlineHandler();
        TaskService local = new TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener(), (EscalatedDeadlineHandler)handler);
        TaskServiceEscalationBaseAsyncTest.testDeadlines(now, handler);
    }
}

