/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.sync;

import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.task.AccessType;
import org.jbpm.task.Attachment;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;
import org.jbpm.task.User;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.utils.CollectionUtils;

public abstract class TaskServiceCommentsAndAttachmentsBaseSyncTest
extends BaseTest {
    protected TaskServer server;
    protected TaskService client;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        super.tearDown();
    }

    public void testAddRemoveComment() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now}), ";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = new PeopleAssignments(),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceCommentsAndAttachmentsBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Comment comment = new Comment();
        Date addedAt = new Date(System.currentTimeMillis());
        comment.setAddedAt(addedAt);
        comment.setAddedBy((User)this.users.get("luke"));
        comment.setText("This is my comment1!!!!!");
        this.client.addComment(taskId, comment);
        long commentId = comment.getId();
        Task task1 = this.client.getTask(taskId);
        List comments1 = task1.getTaskData().getComments();
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((int)1, (int)comments1.size());
        Comment returnedComment = (Comment)comments1.get(0);
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((String)"This is my comment1!!!!!", (String)returnedComment.getText());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((Object)addedAt, (Object)returnedComment.getAddedAt());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals(this.users.get("luke"), (Object)returnedComment.getAddedBy());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((long)commentId, (long)returnedComment.getId());
        task.getTaskData().setComments(comments1);
        task.getTaskData().setStatus(Status.Created);
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((Object)task, (Object)task1);
        comment = new Comment();
        addedAt = new Date(System.currentTimeMillis());
        comment.setAddedAt(addedAt);
        comment.setAddedBy((User)this.users.get("tony"));
        comment.setText("This is my comment2!!!!!");
        this.client.addComment(taskId, comment);
        long commentId2 = comment.getId();
        task1 = this.client.getTask(taskId);
        List comments2 = task1.getTaskData().getComments();
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((int)2, (int)comments2.size());
        comments1.add(comment);
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)comments1, (List)comments2));
        this.client.deleteComment(taskId, commentId2);
        task1 = this.client.getTask(taskId);
        comments2 = task1.getTaskData().getComments();
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((int)1, (int)comments2.size());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((String)"This is my comment1!!!!!", (String)((Comment)comments2.get(0)).getText());
    }

    public void testAddRemoveAttachment() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, activationTime = now}), ";
        str = str + "deadlines = new Deadlines(),";
        str = str + "delegation = new Delegation(),";
        str = str + "peopleAssignments = new PeopleAssignments(),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceCommentsAndAttachmentsBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Attachment attachment = new Attachment();
        Date attachedAt = new Date(System.currentTimeMillis());
        attachment.setAttachedAt(attachedAt);
        attachment.setAttachedBy((User)this.users.get("luke"));
        attachment.setName("file1.txt");
        attachment.setAccessType(AccessType.Inline);
        attachment.setContentType("txt");
        byte[] bytes = "Ths is my attachment text1".getBytes();
        Content content = new Content();
        content.setContent(bytes);
        this.client.addAttachment(taskId, attachment, content);
        Task task1 = this.client.getTask(taskId);
        List attachments1 = task1.getTaskData().getAttachments();
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((int)1, (int)attachments1.size());
        Attachment returnedAttachment = (Attachment)attachments1.get(0);
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((Object)attachedAt, (Object)returnedAttachment.getAttachedAt());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals(this.users.get("luke"), (Object)returnedAttachment.getAttachedBy());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((Object)AccessType.Inline, (Object)returnedAttachment.getAccessType());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((String)"txt", (String)returnedAttachment.getContentType());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((String)"file1.txt", (String)returnedAttachment.getName());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((int)bytes.length, (int)returnedAttachment.getSize());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((long)attachment.getId(), (long)returnedAttachment.getId());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((long)content.getId(), (long)returnedAttachment.getAttachmentContentId());
        task.getTaskData().setAttachments(attachments1);
        task.getTaskData().setStatus(Status.Created);
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((Object)task, (Object)task1);
        content = this.client.getContent(returnedAttachment.getAttachmentContentId());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((String)"Ths is my attachment text1", (String)new String(content.getContent()));
        attachment = new Attachment();
        attachedAt = new Date(System.currentTimeMillis());
        attachment.setAttachedAt(attachedAt);
        attachment.setAttachedBy((User)this.users.get("tony"));
        attachment.setName("file2.txt");
        attachment.setAccessType(AccessType.Inline);
        attachment.setContentType("txt");
        bytes = "Ths is my attachment text2".getBytes();
        content = new Content();
        content.setContent(bytes);
        this.client.addAttachment(taskId, attachment, content);
        task1 = this.client.getTask(taskId);
        List attachments2 = task1.getTaskData().getAttachments();
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((int)2, (int)attachments2.size());
        content = this.client.getContent(content.getId());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((String)"Ths is my attachment text2", (String)new String(content.getContent()));
        attachment.setSize(26);
        attachment.setAttachmentContentId(content.getId());
        attachments1.add(attachment);
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertTrue((boolean)CollectionUtils.equals((List)attachments2, (List)attachments1));
        this.client.deleteAttachment(taskId, attachment.getId().longValue(), content.getId());
        task1 = this.client.getTask(taskId);
        attachments2 = task1.getTaskData().getAttachments();
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((int)1, (int)attachments2.size());
        TaskServiceCommentsAndAttachmentsBaseSyncTest.assertEquals((String)"file1.txt", (String)((Attachment)attachments2.get(0)).getName());
    }
}

