/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.sync;

import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.drools.SystemEventListenerFactory;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.MockEscalatedDeadlineHandler;
import org.jbpm.task.service.TaskServer;

public abstract class TaskServiceEscalationBaseSyncTest
extends BaseTest {
    protected TaskServer server;
    protected TaskService client;

    @Override
    protected void tearDown() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
        if (this.server != null) {
            this.server.stop();
        }
        super.tearDown();
    }

    public void testUnescalatedDeadlines() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        MockEscalatedDeadlineHandler handler = new MockEscalatedDeadlineHandler();
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)handler);
        InputStreamReader reader = new InputStreamReader(TaskServiceEscalationBaseSyncTest.class.getResourceAsStream("/org/jbpm/task/QueryData_UnescalatedDeadlines.mvel"));
        List tasks = (List)TaskServiceEscalationBaseSyncTest.eval(reader, vars);
        long now = ((Date)vars.get("now")).getTime();
        for (Task task : tasks) {
            this.client.addTask(task, null);
        }
        TaskServiceEscalationBaseSyncTest.testDeadlines(now, handler);
    }

    public void testUnescalatedDeadlinesOnStartup() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        InputStreamReader reader = new InputStreamReader(TaskServiceEscalationBaseSyncTest.class.getResourceAsStream("/org/jbpm/task/QueryData_UnescalatedDeadlines.mvel"));
        List tasks = (List)TaskServiceEscalationBaseSyncTest.eval(reader, vars);
        long now = ((Date)vars.get("now")).getTime();
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (Task task : tasks) {
            em.persist((Object)task);
        }
        em.getTransaction().commit();
        MockEscalatedDeadlineHandler handler = new MockEscalatedDeadlineHandler();
        org.jbpm.task.service.TaskService local = new org.jbpm.task.service.TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener(), (EscalatedDeadlineHandler)handler);
        TaskServiceEscalationBaseSyncTest.testDeadlines(now, handler);
    }
}

