/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.hornetq.async;

import org.drools.SystemEventListenerFactory;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.TaskService;
import org.jbpm.task.service.AsyncTaskServiceWrapper;
import org.jbpm.task.service.BaseClientHandler;
import org.jbpm.task.service.ClaimTaskTwiceTest;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.hornetq.HornetQTaskClientConnector;
import org.jbpm.task.service.hornetq.HornetQTaskClientHandler;
import org.jbpm.task.service.hornetq.HornetQTaskServer;

public class ClaimTaskTwiceHornetQAsyncTest
extends ClaimTaskTwiceTest {
    protected TaskServer server;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.server = new HornetQTaskServer(this.taskService, 5153);
        logger.debug("Waiting for the HornetQTask Server to come up");
        try {
            this.startTaskServerThread(this.server, false);
        }
        catch (Exception e) {
            this.startTaskServerThread(this.server, true);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.server.stop();
    }

    @Override
    protected TaskService createClient(String clientName) {
        TaskClient taskClient = new TaskClient((TaskClientConnector)new HornetQTaskClientConnector(clientName, (BaseClientHandler)new HornetQTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
        taskClient.connect("127.0.0.1", 5153);
        AsyncTaskServiceWrapper client = new AsyncTaskServiceWrapper((AsyncTaskService)taskClient);
        return client;
    }

    @Override
    protected void cleanupClient(TaskService client) throws Exception {
        ((AsyncTaskServiceWrapper)client).disconnect();
    }
}

