/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.task.BaseTest;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.query.DeadlineSummary;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.MockEscalatedDeadlineHandler;
import org.jbpm.task.service.persistence.TaskPersistenceManager;

public class QueryTest
extends BaseTest {
    public void testUnescalatedDeadlines() throws Exception {
        MockEscalatedDeadlineHandler handler = new MockEscalatedDeadlineHandler();
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)handler);
        Map<String, Object> vars = this.fillVariables();
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/QueryData_UnescalatedDeadlines.mvel"));
        List tasks = (List)QueryTest.eval(reader, vars);
        for (Task task : tasks) {
            this.taskSession.addTask(task, null);
        }
        long now = ((Date)vars.get("now")).getTime();
        TaskPersistenceManager tpm = new TaskPersistenceManager(this.emf.createEntityManager());
        List list = tpm.getUnescalatedDeadlines();
        QueryTest.assertEquals((int)3, (int)list.size());
        boolean firstDeadlineMet = false;
        boolean secondDeadlineMet = false;
        boolean thirdDeadlineMet = false;
        for (DeadlineSummary summary : list) {
            long deadlineTime = summary.getDate().getTime();
            if (deadlineTime == now + 2000L) {
                firstDeadlineMet = true;
                continue;
            }
            if (deadlineTime == now + 4000L) {
                secondDeadlineMet = true;
                continue;
            }
            if (deadlineTime == now + 6000L) {
                thirdDeadlineMet = true;
                continue;
            }
            QueryTest.fail((String)(deadlineTime + " is not an expected deadline time."));
        }
        QueryTest.assertTrue((String)"First deadline was not met.", (boolean)firstDeadlineMet);
        QueryTest.assertTrue((String)"Second deadline was not met.", (boolean)secondDeadlineMet);
        QueryTest.assertTrue((String)"Third deadline was not met.", (boolean)thirdDeadlineMet);
    }

    public void testPotentialOwnerHibernate4QueryTest() throws Exception {
        TaskPersistenceManager tpm = new TaskPersistenceManager(this.emf.createEntityManager());
        String name = "Bobba Fet";
        Task task = new Task();
        User bobba = new User();
        bobba.setId(name);
        task.setPriority(55);
        TaskData taskData = new TaskData();
        taskData.setActivationTime(new Date());
        taskData.setCreatedOn(new Date());
        taskData.setDocumentContentId(-1L);
        taskData.setFault(-1L, new FaultData());
        taskData.setOutput(-1L, new ContentData());
        taskData.setParentId(-1L);
        taskData.setPreviousStatus(Status.Created);
        taskData.setProcessInstanceId(-1L);
        taskData.setProcessSessionId(0);
        taskData.setSkipable(false);
        taskData.setStatus(Status.Reserved);
        taskData.setWorkItemId(1L);
        task.setTaskData(taskData);
        task.setPeopleAssignments(new PeopleAssignments());
        task.getPeopleAssignments().setPotentialOwners(new ArrayList());
        task.getPeopleAssignments().getPotentialOwners().add(bobba);
        tpm.beginTransaction();
        tpm.saveEntity((Object)task);
        task = (Task)tpm.findEntity(Task.class, (Object)task.getId());
        tpm.endTransaction(true);
        tpm.beginTransaction();
        List list = null;
        list = tpm.queryTasksWithUserIdAndLanguage("TasksAssignedAsPotentialOwner", name, "en-UK");
        tpm.endTransaction(true);
        QueryTest.assertTrue((String)"Query did not succeed.", (list.size() > 0 ? 1 : 0) != 0);
    }
}

