/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.test.impl;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.test.impl.TestServerUtil;
import org.jbpm.task.service.test.impl.TestTaskServerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTestTaskServer
extends TaskServer {
    private static final Logger logger = LoggerFactory.getLogger(TaskServer.class);
    private volatile AtomicBoolean running = new AtomicBoolean();
    private volatile CountDownLatch finished;
    private boolean latchGiven = false;
    private BlockingQueue<byte[]> consumer;
    private BlockingQueue<byte[]> producer;
    private TestTaskServerHandler handler;
    private final boolean defaultToSequentialOperation = true;

    BaseTestTaskServer(TestTaskServerHandler handler) {
        this(handler, null);
    }

    BaseTestTaskServer(TestTaskServerHandler handler, Boolean sequentialOperation) {
        if (sequentialOperation == null) {
            sequentialOperation = true;
        }
        if (sequentialOperation.booleanValue()) {
            this.consumer = new ArrayBlockingQueue<byte[]>(1, true);
            this.producer = new ArrayBlockingQueue<byte[]>(1, true);
        } else {
            this.consumer = new LinkedBlockingQueue<byte[]>();
            this.producer = new LinkedBlockingQueue<byte[]>();
        }
        this.handler = handler;
    }

    public void run() {
        try {
            this.start();
            while (this.running.get()) {
                byte[] messageBytes = this.consumer.take();
                if (messageBytes == null || messageBytes.length <= 0) continue;
                TestServerUtil.pause();
                Object message = TestServerUtil.deserialize(messageBytes);
                this.handler.messageReceived(this.producer, message);
            }
            this.finished.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn("Server failed.", (Throwable)e);
            throw new RuntimeException("Test Server failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AtomicBoolean atomicBoolean = this.running;
        synchronized (atomicBoolean) {
            this.running.set(true);
            this.running.notifyAll();
        }
    }

    public void stop() {
        this.running.set(false);
        try {
            this.consumer.clear();
            this.consumer.put(new byte[0]);
            this.consumer = null;
            this.producer.clear();
            long numClients = this.finished.getCount();
            int i = 0;
            while ((long)i < numClients) {
                this.producer.offer(new byte[0]);
                ++i;
            }
            if (this.latchGiven) {
                boolean done = false;
                while (!done) {
                    try {
                        this.finished.await(2L, TimeUnit.SECONDS);
                        done = true;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    int i2 = 0;
                    while ((long)i2 < numClients) {
                        this.producer.offer(new byte[0]);
                        ++i2;
                    }
                }
            }
            this.producer = null;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.handler = null;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    AtomicBoolean getRunningNotifier() {
        return this.running;
    }

    BlockingQueue<byte[]>[] getQueues() {
        return new BlockingQueue[]{this.consumer, this.producer};
    }

    Object[] getFlags() {
        this.latchGiven = true;
        return new Object[]{this.running, this.finished};
    }

    void setNumberOfClients(int numClients) {
        if (this.finished != null) {
            throw new IllegalStateException("The number of clients has already been set for this server.");
        }
        this.finished = new CountDownLatch(numClients + 1);
    }
}

