/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import javax.persistence.EntityManager;
import org.drools.persistence.TransactionManager;
import org.jbpm.task.service.persistence.TaskTransactionManager;

class TaskSpringTransactionManager
implements TaskTransactionManager {
    public static final int STATUS_ROLLBACK_ONLY = 5;
    private TransactionManager tm;
    private boolean useJTA;

    TaskSpringTransactionManager(TransactionManager springTransactionManager, boolean useJTA) {
        this.tm = springTransactionManager;
        this.useJTA = useJTA;
    }

    @Override
    public void attachPersistenceContext(EntityManager em) {
        if (this.useJTA) {
            em.joinTransaction();
        }
    }

    @Override
    public boolean begin(EntityManager em) {
        boolean owner = this.tm.begin();
        return owner;
    }

    @Override
    public void commit(EntityManager em, boolean txOwner) {
        this.tm.commit(txOwner);
    }

    @Override
    public void rollback(EntityManager em, boolean txOwner) {
        int status = this.tm.getStatus();
        switch (status) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                this.tm.rollback(txOwner);
                break;
            }
            default: {
                throw new RuntimeException("Unknown transaction state when rolling back.");
            }
        }
    }

    @Override
    public int getStatus(EntityManager em) {
        return this.tm.getStatus();
    }

    @Override
    public void dispose() {
        int status = this.tm.getStatus();
        if (status == 4) {
            try {
                this.tm.commit(true);
            }
            catch (RuntimeException t) {}
        } else if (status == 5) {
            try {
                this.tm.rollback(true);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.tm = null;
    }
}

