/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.scripts;

import java.io.File;
import org.hibernate.Version;
import org.jbpm.persistence.scripts.PersistenceUnit;
import org.jbpm.persistence.scripts.TestPersistenceContext;
import org.jbpm.persistence.scripts.util.TestsUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDLScriptsTest {
    private static final Logger logger = LoggerFactory.getLogger(DDLScriptsTest.class);

    @BeforeClass
    public static void printHibernateVersion() {
        logger.info("Running with Hibernate " + Version.getVersionString());
    }

    @Before
    public void clearSchema() {
        TestsUtil.clearSchema();
    }

    @Test
    public void createSchemaUsingDDLs() throws Exception {
        TestPersistenceContext scriptRunnerContext = this.createAndInitPersistenceContext(PersistenceUnit.SCRIPT_RUNNER);
        try {
            scriptRunnerContext.executeScripts(new File(this.getClass().getResource("/ddl-scripts").getFile()));
        }
        finally {
            scriptRunnerContext.clean();
        }
        TestPersistenceContext dbTestingContext = this.createAndInitPersistenceContext(PersistenceUnit.DB_TESTING_VALIDATE);
        try {
            dbTestingContext.startAndPersistSomeProcess("minimalProcess");
            Assert.assertTrue((dbTestingContext.getStoredProcessesCount() == 1 ? 1 : 0) != 0);
        }
        finally {
            dbTestingContext.clean();
        }
    }

    @Test
    public void runHibernateUpdateOnEmptyDB() throws Exception {
        TestPersistenceContext dbTestingContext = this.createAndInitPersistenceContext(PersistenceUnit.DB_TESTING_UPDATE);
        dbTestingContext.clean();
    }

    @Test
    public void createSchemaWithDDLsAndRunHibernateUpdate() throws Exception {
        TestPersistenceContext scriptRunnerContext = this.createAndInitPersistenceContext(PersistenceUnit.SCRIPT_RUNNER);
        try {
            scriptRunnerContext.executeScripts(new File(this.getClass().getResource("/ddl-scripts").getFile()));
        }
        finally {
            scriptRunnerContext.clean();
        }
        TestPersistenceContext dbTestingContext = this.createAndInitPersistenceContext(PersistenceUnit.DB_TESTING_UPDATE);
        dbTestingContext.clean();
    }

    private TestPersistenceContext createAndInitPersistenceContext(PersistenceUnit persistenceUnit) {
        TestPersistenceContext testPersistenceContext = new TestPersistenceContext();
        testPersistenceContext.init(persistenceUnit);
        return testPersistenceContext;
    }
}

