/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.scripts.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jbpm.persistence.scripts.DatabaseType;

public final class SQLScriptUtil {
    private static final String DELIMITER_STANDARD = ";";
    private static final String DELIMITER_MSSQL = "GO";

    public static List<String> getCommandsFromScript(File script, DatabaseType databaseType) throws IOException {
        List scriptLines = FileUtils.readLines((File)script);
        ArrayList<String> foundCommands = new ArrayList<String>();
        StringBuilder command = new StringBuilder();
        for (String line : scriptLines) {
            if (line.startsWith("--") || line.startsWith("#")) continue;
            if ((line.equals(DELIMITER_STANDARD) || (databaseType == DatabaseType.SQLSERVER || databaseType == DatabaseType.SQLSERVER2008) && line.equals(DELIMITER_MSSQL)) && !"".equals(command.toString())) {
                foundCommands.add(command.toString());
                command.setLength(0);
                command.trimToSize();
            }
            if (line.contains(DELIMITER_STANDARD)) {
                SQLScriptUtil.extractCommandsFromLine(line, "\\;", command, foundCommands);
                continue;
            }
            if ((databaseType == DatabaseType.SQLSERVER || databaseType == DatabaseType.SQLSERVER2008) && line.contains(DELIMITER_MSSQL)) {
                SQLScriptUtil.extractCommandsFromLine(line, DELIMITER_MSSQL, command, foundCommands);
                continue;
            }
            command.append(line).append(" ");
        }
        if (!"".equals(command.toString())) {
            foundCommands.add(command.toString());
        }
        return foundCommands;
    }

    private static void extractCommandsFromLine(String line, String delimiter, StringBuilder bufferedCommand, List<String> extractedCommands) {
        String[] lineParts = line.split(delimiter);
        for (int i = 0; i < lineParts.length; ++i) {
            if (i == 0) {
                extractedCommands.add(bufferedCommand.toString() + " " + lineParts[i]);
                bufferedCommand.setLength(0);
                bufferedCommand.trimToSize();
                continue;
            }
            if (i == lineParts.length - 1 && !line.endsWith(delimiter)) {
                bufferedCommand.append(lineParts[i]);
                continue;
            }
            extractedCommands.add(lineParts[i]);
        }
    }

    private SQLScriptUtil() {
    }
}

