/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.scripts.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import org.jbpm.persistence.scripts.DatabaseType;
import org.jbpm.persistence.scripts.PersistenceUnit;
import org.jbpm.persistence.scripts.TestPersistenceContext;

public final class TestsUtil {
    public static File[] getDDLScriptFilesByDatabaseType(File folderWithDDLs, DatabaseType databaseType, boolean sortByName) {
        File folderWithScripts = new File(folderWithDDLs.getPath() + File.separator + databaseType.getScriptsFolderName());
        if (folderWithScripts.exists()) {
            File[] foundFiles = folderWithScripts.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".sql");
                }
            });
            if (foundFiles == null) {
                return new File[0];
            }
            if (sortByName) {
                Arrays.sort(foundFiles, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
            }
            return foundFiles;
        }
        return new File[0];
    }

    public static DatabaseType getDatabaseType(Properties dataSourceProperties) {
        String hibernateDialect = dataSourceProperties.getProperty("dialect");
        if (!"".equals(hibernateDialect)) {
            return TestsUtil.getDatabaseTypeBySQLDialect(hibernateDialect);
        }
        return DatabaseType.H2;
    }

    public static DatabaseType getDatabaseTypeBySQLDialect(String sqlDialect) {
        if (sqlDialect.contains("DB2Dialect")) {
            return DatabaseType.DB2;
        }
        if (sqlDialect.contains("DerbyDialect")) {
            return DatabaseType.DERBY;
        }
        if (sqlDialect.contains("H2Dialect")) {
            return DatabaseType.H2;
        }
        if (sqlDialect.contains("HSQLDialect")) {
            return DatabaseType.HSQLDB;
        }
        if (sqlDialect.contains("MySQL5Dialect")) {
            return DatabaseType.MYSQL5;
        }
        if (sqlDialect.contains("MySQL5InnoDBDialect")) {
            return DatabaseType.MYSQLINNODB;
        }
        if (sqlDialect.contains("Oracle")) {
            return DatabaseType.ORACLE;
        }
        if (sqlDialect.contains("Postgre")) {
            return DatabaseType.POSTGRESQL;
        }
        if (sqlDialect.contains("SQLServer2008Dialect") || sqlDialect.contains("SQLServer2012Dialect")) {
            return DatabaseType.SQLSERVER2008;
        }
        if (sqlDialect.contains("SQLServerDialect") || sqlDialect.contains("SQLServer2005Dialect")) {
            return DatabaseType.SQLSERVER;
        }
        throw new IllegalArgumentException("SQL dialect type " + sqlDialect + " is not supported!");
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }

    public static void clearSchema() {
        TestPersistenceContext clearSchemaContext = new TestPersistenceContext();
        clearSchemaContext.init(PersistenceUnit.CLEAR_SCHEMA);
        clearSchemaContext.clean();
    }

    private TestsUtil() {
    }
}

