/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.scripts;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.hibernate.Version;
import org.jbpm.persistence.scripts.PersistenceUnit;
import org.jbpm.persistence.scripts.TestPersistenceContext;
import org.jbpm.persistence.scripts.util.TestsUtil;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptsBase {
    protected static final String DB_DDL_SCRIPTS_RESOURCE_PATH = "/db/ddl-scripts";
    protected static final String TEST_PROCESS_ID = "minimalProcess";
    private static final Logger logger = LoggerFactory.getLogger(ScriptsBase.class);
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            logger.info(">>>> Starting test: " + description.getMethodName());
        }
    };

    @BeforeClass
    public static void cleanUp() throws IOException, SQLException {
        logger.info("Running with Hibernate " + Version.getVersionString());
        TestsUtil.clearSchema();
        ScriptsBase.executeScriptRunner(DB_DDL_SCRIPTS_RESOURCE_PATH, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void executeScriptRunner(String resourcePath, boolean createFiles, String type) throws IOException, SQLException {
        TestPersistenceContext scriptRunnerContext = TestPersistenceContext.createAndInitContext(PersistenceUnit.SCRIPT_RUNNER);
        try {
            scriptRunnerContext.executeScripts(new File(ScriptsBase.class.getResource(resourcePath).getFile()), createFiles, type);
        }
        finally {
            scriptRunnerContext.clean();
        }
    }

    protected static void executeScriptRunner(String resourcePath, boolean createFiles) throws IOException, SQLException {
        TestPersistenceContext scriptRunnerContext = TestPersistenceContext.createAndInitContext(PersistenceUnit.SCRIPT_RUNNER);
        try {
            scriptRunnerContext.executeScripts(new File(ScriptsBase.class.getResource(resourcePath).getFile()), createFiles);
        }
        finally {
            scriptRunnerContext.clean();
        }
    }
}

