/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.scripts;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.persistence.map.impl.ProcessCreatorForHelp;
import org.jbpm.persistence.scripts.DatabaseType;
import org.jbpm.persistence.scripts.PersistenceUnit;
import org.jbpm.persistence.scripts.oldentities.ProcessInstanceInfo;
import org.jbpm.persistence.scripts.oldentities.SessionInfo;
import org.jbpm.persistence.scripts.oldentities.TaskImpl;
import org.jbpm.persistence.scripts.util.SQLCommandUtil;
import org.jbpm.persistence.scripts.util.SQLScriptUtil;
import org.jbpm.persistence.scripts.util.TestsUtil;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.test.util.PoolingDataSource;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.Environment;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.TaskData;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalI18NText;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTaskData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestPersistenceContext {
    private static final Logger logger = LoggerFactory.getLogger(TestPersistenceContext.class);
    private HashMap<String, Object> context;
    private EntityManagerFactory entityManagerFactory;
    private JtaTransactionManager transactionManager;
    private Environment environment;
    private final Properties dataSourceProperties = PersistenceUtil.getDatasourceProperties();
    private final DatabaseType databaseType = TestsUtil.getDatabaseType(this.dataSourceProperties);

    public void init(PersistenceUnit persistenceUnit) {
        try {
            this.context = PersistenceUtil.setupWithPoolingDataSource((String)persistenceUnit.getName(), (String)persistenceUnit.getDataSourceName());
            this.entityManagerFactory = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
            this.environment = PersistenceUtil.createEnvironment(this.context);
            Object tm = this.environment.get("org.kie.transaction.TransactionManager");
            this.transactionManager = new JtaTransactionManager(this.environment.get("org.kie.transaction.Transaction"), this.environment.get("org.kie.transaction.TransactionSynchronizationRegistry"), tm);
        }
        catch (RuntimeException ex) {
            logger.error("Failed to initialize persistence unit {}", (Object)persistenceUnit, (Object)ex);
            if (this.entityManagerFactory != null) {
                this.entityManagerFactory.close();
            }
            throw ex;
        }
    }

    public void clean() {
        PersistenceUtil.cleanUp(this.context);
    }

    public void executeScripts(File scriptsRootFolder) throws IOException, SQLException {
        this.executeScripts(scriptsRootFolder, null);
    }

    public void executeScripts(File scriptsRootFolder, String type) throws IOException, SQLException {
        this.testIsInitialized();
        File[] sqlScripts = TestsUtil.getDDLScriptFilesByDatabaseType(scriptsRootFolder, this.databaseType, true);
        connection.setAutoCommit(false);
        try (Connection connection = ((PoolingDataSource)this.context.get(PersistenceUtil.DATASOURCE)).getConnection();){
            for (File script : sqlScripts) {
                if (type != null && !script.getName().startsWith(type)) continue;
                logger.debug("Executing script {}", (Object)script.getName());
                List<String> scriptCommands = SQLScriptUtil.getCommandsFromScript(script, this.databaseType);
                for (String command : scriptCommands) {
                    logger.debug(command);
                    PreparedStatement statement = this.databaseType == DatabaseType.SQLSERVER || this.databaseType == DatabaseType.SQLSERVER2008 ? connection.prepareStatement(SQLCommandUtil.preprocessCommandSqlServer(command, this.dataSourceProperties)) : connection.prepareStatement(command);
                    statement.execute();
                    statement.close();
                }
            }
            connection.commit();
        }
    }

    public void startAndPersistSomeProcess(String processId) {
        this.testIsInitialized();
        KieBase kbase = this.createKieBase(processId);
        StatefulKnowledgeSession session = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.environment);
        session.startProcess(processId);
    }

    public void createSomeTask() {
        this.testIsInitialized();
        TaskImpl task = new TaskImpl();
        InternalI18NText name = (InternalI18NText)TaskModelProvider.getFactory().newI18NText();
        name.setText("Some Task");
        ArrayList<I18NText> names = new ArrayList<I18NText>();
        names.add((I18NText)name);
        task.setNames(names);
        InternalTaskData taskData = (InternalTaskData)TaskModelProvider.getFactory().newTaskData();
        taskData.setWorkItemId(12L);
        taskData.setProcessInstanceId(1L);
        taskData.setProcessId("someprocess");
        taskData.setDeploymentId("org.jbpm.test:someprocess:1.0");
        taskData.setProcessSessionId(1L);
        task.setTaskData((TaskData)taskData);
        InternalPeopleAssignments peopleAssignments = (InternalPeopleAssignments)TaskModelProvider.getFactory().newPeopleAssignments();
        peopleAssignments.setPotentialOwners(new ArrayList());
        peopleAssignments.setBusinessAdministrators(new ArrayList());
        peopleAssignments.setExcludedOwners(new ArrayList());
        peopleAssignments.setRecipients(new ArrayList());
        peopleAssignments.setTaskStakeholders(new ArrayList());
        InternalOrganizationalEntity jdoe = (InternalOrganizationalEntity)TaskModelProvider.getFactory().newUser();
        jdoe.setId("jdoe");
        peopleAssignments.getPotentialOwners().add(jdoe);
        peopleAssignments.getBusinessAdministrators().add(jdoe);
        task.setPeopleAssignments((PeopleAssignments)peopleAssignments);
        boolean txOwner = this.transactionManager.begin();
        try {
            EntityManager em = this.entityManagerFactory.createEntityManager();
            em.persist((Object)jdoe);
            em.persist((Object)task);
            this.transactionManager.commit(txOwner);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.transactionManager.rollback(txOwner);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public StatefulKnowledgeSession loadPersistedSession(Long sessionId, String processIdForKieBase) {
        this.testIsInitialized();
        return JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionId, (KieBase)this.createKieBase(processIdForKieBase), null, (Environment)this.environment);
    }

    public void persistOldProcessAndSession(Integer sessionId, String processId, Long processInstanceId) {
        this.testIsInitialized();
        boolean txOwner = this.transactionManager.begin();
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            entityManager.merge((Object)this.getOldProcessInstanceInfo(processId, processInstanceId));
            entityManager.merge((Object)this.getOldSessionInfo(sessionId));
            entityManager.flush();
            entityManager.close();
            this.transactionManager.commit(txOwner);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.transactionManager.rollback(txOwner);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public int getStoredProcessesCount() {
        return this.getStoredEntitiesCount("ProcessInstanceInfo");
    }

    public int getStoredSessionsCount() {
        return this.getStoredEntitiesCount("SessionInfo");
    }

    private int getStoredEntitiesCount(String entityClassName) {
        this.testIsInitialized();
        boolean txOwner = this.transactionManager.begin();
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            List entitiesList = entityManager.createQuery("SELECT p FROM " + entityClassName + " p").getResultList();
            if (entitiesList == null) {
                int n = 0;
                return n;
            }
            int n = entitiesList.size();
            return n;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.transactionManager.rollback(txOwner);
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            entityManager.close();
            this.transactionManager.commit(txOwner);
        }
    }

    private void testIsInitialized() {
        if (this.context == null) {
            throw new IllegalStateException("TestContext is not initialized! Call TestContext.init() before using it.");
        }
    }

    private KieBase createKieBase(String ... processIds) {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        for (String processId : processIds) {
            ((KnowledgeBaseImpl)kbase).addProcess((Process)ProcessCreatorForHelp.newSimpleEventProcess((String)processId, (String)"test"));
        }
        return kbase;
    }

    private ProcessInstanceInfo getOldProcessInstanceInfo(String processId, Long processInstanceId) throws ParseException {
        DateFormat dateFormat = this.getDateFormat();
        ProcessInstanceInfo result = new ProcessInstanceInfo();
        result.setProcessInstanceId(processInstanceId);
        result.setEventTypes(this.getOldProcessEventTypes());
        result.setLastModificationDate(dateFormat.parse("2015-08-25 13:43:25.760"));
        result.setLastReadDate(dateFormat.parse("2015-08-25 13:43:25.210"));
        result.setProcessId(processId);
        result.setStartDate(dateFormat.parse("2015-08-25 13:43:25.190"));
        result.setState(1);
        result.setVersion(2);
        result.setProcessInstanceByteArray(TestsUtil.hexStringToByteArray("ACED00057769000852756C65466C6F770A0608061004180052550A0852756C65466C6F7710011A0E6D696E696D616C50726F63657373200128023A0A0801100222020805280160006A0E5F6A62706D2D756E697175652D3072120A0E5F6A62706D2D756E697175652D311001800101"));
        return result;
    }

    private Set<String> getOldProcessEventTypes() {
        HashSet<String> resultSet = new HashSet<String>(1);
        resultSet.add("test");
        return resultSet;
    }

    private SessionInfo getOldSessionInfo(Integer sessionId) throws ParseException {
        DateFormat dateFormat = this.getDateFormat();
        SessionInfo result = new SessionInfo();
        result.setId(sessionId);
        result.setLastModificationDate(dateFormat.parse("2015-08-25 13:43:25.248"));
        result.setStartDate(dateFormat.parse("2015-08-25 13:43:24.858"));
        result.setVersion(2);
        result.setData(TestsUtil.hexStringToByteArray("ACED0005777C0A060806100418005272080010001A6818002000320608011000180042231A190A044D41494E10001801200028FFFFFFFFFFFFFFFFFF01400022060A044D41494E52350A0744454641554C54222A0A266F72672E64726F6F6C732E636F72652E726574656F6F2E496E697469616C46616374496D706C100022026800"));
        return result;
    }

    private DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }
}

