/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import org.drools.persistence.util.PersistenceUtil;
import org.jbpm.persistence.processinstance.objects.UserTypePropertyHolder;
import org.jbpm.persistence.session.objects.MyEntity;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BlobUserTypeTest {
    private HashMap<String, Object> context;
    private static boolean runTests = true;

    @BeforeClass
    public static void beforeClass() {
        runTests = BlobUserTypeTest.usingHibernate3();
    }

    @Before
    public void before() {
        if (runTests) {
            this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa", (boolean)false);
        }
    }

    @After
    public void after() {
        if (runTests) {
            PersistenceUtil.cleanUp(this.context);
        }
    }

    @Test
    public void testHolderWithBlobUserType() throws Exception {
        if (!runTests) {
            return;
        }
        MyEntity test = new MyEntity();
        EntityManager em = this.openTx();
        em.persist((Object)test);
        this.closeTx(em);
        System.out.println("test: " + test.getId());
        UserTypePropertyHolder holder = new UserTypePropertyHolder();
        String stringTest = "This is a test string.";
        byte[] blob = stringTest.getBytes();
        holder.setBlobInfo(blob);
        EntityManager em2 = this.openTx();
        em2.persist((Object)holder);
        this.closeTx(em2);
        int id = holder.getId();
        Assert.assertTrue((id > 0 ? 1 : 0) != 0);
    }

    private EntityManager openTx() throws Exception {
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("drools.persistence.jpa.EntityManagerFactory");
        EntityManager em = emf.createEntityManager();
        em.setFlushMode(FlushModeType.COMMIT);
        em.joinTransaction();
        return em;
    }

    private void closeTx(EntityManager em) throws Exception {
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        em.close();
        ut.commit();
    }

    private static boolean usingHibernate3() {
        boolean hibernateCreateBlobMethodExists = false;
        try {
            Class<?> LobHelperClass = Class.forName("org.hibernate.Hibernate");
            byte[] byteArray = new byte[]{};
            Method createBlobMethod = LobHelperClass.getMethod("createBlob", byteArray.getClass());
            hibernateCreateBlobMethodExists = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hibernateCreateBlobMethodExists;
    }
}

