/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.drools.marshalling.util.CompareViaReflectionUtil;
import org.drools.marshalling.util.MarshalledData;
import org.drools.marshalling.util.MarshallingDBUtil;
import org.drools.marshalling.util.MarshallingTestUtil;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.drools.persistence.util.PersistenceUtil;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugJbpmUnmarshallingTest {
    private static Logger logger = LoggerFactory.getLogger(DebugJbpmUnmarshallingTest.class);

    @Test
    @Ignore
    public void testWriteReadUTF() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(baos);
        stream.writeUTF("org.drools.test.TestProcess");
        byte[] resultBytes = baos.toByteArray();
        stream.close();
        resultBytes = baos.toByteArray();
        Assert.assertTrue((resultBytes != null && resultBytes.length > 0 ? 1 : 0) != 0);
        ByteArrayInputStream bais = new ByteArrayInputStream(resultBytes);
        ObjectInputStream inStream = new ObjectInputStream(bais);
        String result = null;
        try {
            result = inStream.readUTF();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(e.getClass().getSimpleName() + " thrown: " + e.getMessage()));
        }
        System.out.println(": \"" + result + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void debugUnmarshallingSpecificMarshalledData() {
        HashSet<String> testMethodAndSnapNumSet = new HashSet<String>();
        testMethodAndSnapNumSet.add("org.jbpm.persistence.session.PersistentStatefulSessionTest.testPersistenceWorkItems2:2");
        testMethodAndSnapNumSet.add("org.jbpm.persistence.session.PersistentStatefulSessionTest.testPersistenceWorkItems3:5");
        HashMap testContext = MarshallingDBUtil.initializeMarshalledDataEMF((String)"org.jbpm.persistence.jpa", this.getClass(), (boolean)true);
        EntityManagerFactory emf = (EntityManagerFactory)testContext.get("drools.persistence.jpa.EntityManagerFactory");
        ArrayList marshalledDataList = MarshallingTestUtil.retrieveMarshallingData((EntityManagerFactory)emf);
        HashSet<MarshalledData> marshalledDataSet = new HashSet<MarshalledData>();
        for (MarshalledData marshalledDataElement : marshalledDataList) {
            if (!testMethodAndSnapNumSet.contains(marshalledDataElement.getTestMethodAndSnapshotNum())) continue;
            marshalledDataSet.add(marshalledDataElement);
            break;
        }
        Assert.assertTrue((String)"No marshalled data retrieved.", (!marshalledDataSet.isEmpty() ? 1 : 0) != 0);
        String logMsg = null;
        try {
            Object unmarshalledObject = null;
            for (MarshalledData marshalledData : marshalledDataSet) {
                logMsg = marshalledData.marshalledObjectClassName.substring(marshalledData.marshalledObjectClassName.lastIndexOf(46) + 1) + ": " + marshalledData.getTestMethodAndSnapshotNum();
                unmarshalledObject = MarshallingTestUtil.unmarshallObject((MarshalledData)marshalledData);
                Assert.assertNotNull((Object)unmarshalledObject);
                logger.info(".: " + logMsg);
            }
        }
        catch (Exception e) {
            logger.info("X: " + logMsg);
            e.printStackTrace();
            Assert.fail((String)("[" + e.getClass().getSimpleName() + "]: " + e.getMessage()));
        }
        finally {
            PersistenceUtil.tearDown((HashMap)testContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void compareUnmarshalledObjects() {
        HashSet<String> testMethodAndSnapNumSet = new HashSet<String>();
        testMethodAndSnapNumSet.add("org.jbpm.persistence.session.PersistentStatefulSessionTest.testPersistenceWorkItems2:2");
        boolean[] dbType = new boolean[]{true, false};
        Object[] objects = new Object[2];
        for (int i = 0; i < objects.length; ++i) {
            HashMap testContext = MarshallingDBUtil.initializeMarshalledDataEMF((String)"org.jbpm.persistence.jpa", this.getClass(), (boolean)dbType[i], (String)"5.2.0");
            EntityManagerFactory emf = (EntityManagerFactory)testContext.get("drools.persistence.jpa.EntityManagerFactory");
            ArrayList marshalledDataList = MarshallingTestUtil.retrieveMarshallingData((EntityManagerFactory)emf);
            HashSet<MarshalledData> marshalledDataSet = new HashSet<MarshalledData>();
            for (MarshalledData marshalledDataElement : marshalledDataList) {
                if (!testMethodAndSnapNumSet.contains(marshalledDataElement.getTestMethodAndSnapshotNum())) continue;
                marshalledDataSet.add(marshalledDataElement);
                break;
            }
            Assert.assertFalse((String)("No marshalled data retrieved [" + i + "]"), (boolean)marshalledDataSet.isEmpty());
            Assert.assertTrue((String)"Not all marshalled data was retrieved.", (marshalledDataSet.size() == testMethodAndSnapNumSet.size() ? 1 : 0) != 0);
            Assert.assertTrue((String)("Too much marshalled data was retrieved [" + marshalledDataSet.size() + "]"), (marshalledDataSet.size() == 1 ? 1 : 0) != 0);
            Object unmarshalledObject = null;
            try {
                for (MarshalledData marshalledData : marshalledDataSet) {
                    unmarshalledObject = MarshallingTestUtil.unmarshallObject((MarshalledData)marshalledData);
                    Assert.assertNotNull((Object)unmarshalledObject);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("[" + e.getClass().getSimpleName() + "]: " + e.getMessage()));
            }
            finally {
                PersistenceUtil.tearDown((HashMap)testContext);
            }
            objects[i] = unmarshalledObject;
        }
        Assert.assertTrue((String)"Not the same", (boolean)CompareViaReflectionUtil.compareInstances((Object)objects[0], (Object)objects[1]));
    }

    @Test
    @Ignore
    public void checkMarshalledProcessInstanceObjects() {
        List<MarshalledData> marshalledDataList = this.retrieveMarshallingDataForTest(true);
        this.unmarshallAllObjectsOfClass(marshalledDataList, ProcessInstanceInfo.class.getName());
    }

    @Test
    @Ignore
    public void checkMarshalledWorkItemObjects() throws IOException {
        List<MarshalledData> marshalledDataList = this.retrieveMarshallingDataForTest(false);
        this.unmarshallAllObjectsOfClass(marshalledDataList, WorkItemInfo.class.getName());
    }

    @Test
    @Ignore
    public void checkMarshalledSessionInfoObjects() throws IOException {
        List<MarshalledData> marshalledDataList = this.retrieveMarshallingDataForTest(true);
        this.unmarshallAllObjectsOfClass(marshalledDataList, SessionInfo.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MarshalledData> retrieveMarshallingDataForTest(boolean fromBase) {
        HashMap testContext = null;
        ArrayList marshalledDataList = new ArrayList();
        try {
            testContext = MarshallingDBUtil.initializeMarshalledDataEMF((String)"org.jbpm.persistence.jpa", this.getClass(), (boolean)fromBase);
            EntityManagerFactory emf = (EntityManagerFactory)testContext.get("drools.persistence.jpa.EntityManagerFactory");
            marshalledDataList = MarshallingTestUtil.retrieveMarshallingData((EntityManagerFactory)emf);
        }
        catch (Throwable throwable) {
            PersistenceUtil.tearDown(testContext);
            throw throwable;
        }
        PersistenceUtil.tearDown((HashMap)testContext);
        return marshalledDataList;
    }

    private void unmarshallAllObjectsOfClass(List<MarshalledData> marshalledDataList, String className) {
        for (MarshalledData marshalledData : marshalledDataList) {
            if (!marshalledData.marshalledObjectClassName.equals(className)) continue;
            String logMsg = marshalledData.marshalledObjectClassName.substring(marshalledData.marshalledObjectClassName.lastIndexOf(46) + 1) + ": " + marshalledData.getTestMethodAndSnapshotNum();
            try {
                MarshallingTestUtil.unmarshallObject((MarshalledData)marshalledData);
                logger.info(".: " + logMsg);
            }
            catch (Exception e) {
                logger.info("X: " + logMsg);
                StackTraceElement[] ste = e.getStackTrace();
                for (int i = 0; i < 1; ++i) {
                    StringBuilder elemMsg = new StringBuilder();
                    elemMsg.append("  " + ste[i].getClassName() + ":");
                    elemMsg.append(ste[i].getMethodName() + " [");
                    elemMsg.append(ste[i].getLineNumber() + "]");
                    System.out.println(elemMsg);
                }
            }
        }
    }
}

