/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.session;

import java.util.HashMap;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.jbpm.persistence.JbpmTestCase;
import org.jbpm.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.KieBase;
import org.kie.KnowledgeBase;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;
import org.kie.persistence.jpa.JPAKnowledgeService;
import org.kie.runtime.Environment;
import org.kie.runtime.StatefulKnowledgeSession;

public class GetProcessInstancesTest
extends JbpmTestCase {
    private HashMap<String, Object> context;
    private Environment env;
    private KnowledgeBase kbase;
    private int sessionId;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
        this.kbase = this.createBase();
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)this.kbase, null, (Environment)this.env);
        this.sessionId = ksession.getId();
        ksession.dispose();
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void getEmptyProcessInstances() throws Exception {
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        GetProcessInstancesTest.assertEquals((int)0, (int)ksession.getProcessInstances().size());
        ksession.dispose();
    }

    @Test
    public void create2ProcessInstances() throws Exception {
        long[] processId = new long[2];
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        processId[0] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        processId[1] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        ksession.dispose();
        this.assertProcessInstancesExist(processId);
    }

    @Test
    public void create2ProcessInstancesInsideTransaction() throws Exception {
        long[] processId = new long[2];
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        processId[0] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        processId[1] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        GetProcessInstancesTest.assertEquals((int)2, (int)ksession.getProcessInstances().size());
        ut.commit();
        GetProcessInstancesTest.assertEquals((int)0, (int)ksession.getProcessInstances().size());
        ksession = this.reloadKnowledgeSession(ksession);
        GetProcessInstancesTest.assertEquals((int)0, (int)ksession.getProcessInstances().size());
        ksession.dispose();
        this.assertProcessInstancesExist(processId);
    }

    @Test
    public void noProcessInstancesLeftAfterRollback() throws Exception {
        long[] notProcess = new long[2];
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        notProcess[0] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        notProcess[1] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        GetProcessInstancesTest.assertEquals((int)2, (int)ksession.getProcessInstances().size());
        ut.rollback();
        GetProcessInstancesTest.assertEquals((int)0, (int)ksession.getProcessInstances().size());
        ksession = this.reloadKnowledgeSession(ksession);
        GetProcessInstancesTest.assertEquals((int)0, (int)ksession.getProcessInstances().size());
        ksession.dispose();
        this.assertProcessInstancesNotExist(notProcess);
    }

    @Test
    public void noProcessInstancesLeftWithPreTxKSessionAndRollback() throws Exception {
        long[] notProcess = new long[4];
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        notProcess[0] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        notProcess[1] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        ut.rollback();
        GetProcessInstancesTest.assertEquals((int)0, (int)ksession.getProcessInstances().size());
        ksession = this.reloadKnowledgeSession(ksession);
        GetProcessInstancesTest.assertEquals((int)0, (int)ksession.getProcessInstances().size());
        ksession.dispose();
        this.assertProcessInstancesNotExist(notProcess);
    }

    private void assertProcessInstancesExist(long[] processId) {
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        for (long id : processId) {
            GetProcessInstancesTest.assertNotNull((String)("Process instance " + id + " should not exist!"), (Object)ksession.getProcessInstance(id));
        }
    }

    private void assertProcessInstancesNotExist(long[] processId) {
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        for (long id : processId) {
            GetProcessInstancesTest.assertNull((Object)ksession.getProcessInstance(id));
        }
    }

    private KnowledgeBase createBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"processinstance/HelloWorld.rf"), ResourceType.DRF);
        GetProcessInstancesTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        return kbuilder.newKnowledgeBase();
    }

    private StatefulKnowledgeSession reloadKnowledgeSession() {
        return JPAKnowledgeService.loadStatefulKnowledgeSession((int)this.sessionId, (KieBase)this.kbase, null, (Environment)this.env);
    }

    private StatefulKnowledgeSession reloadKnowledgeSession(StatefulKnowledgeSession ksession) {
        ksession.dispose();
        return this.reloadKnowledgeSession();
    }
}

