/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.util;

import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPrintStream
extends PrintStream {
    private Logger logger;
    private StringBuilder buffer = new StringBuilder();

    public LoggingPrintStream(OutputStream outputStream) {
        super(outputStream);
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        try {
            this.logger = LoggerFactory.getLogger(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
    }

    protected void log(String s) {
        this.logger.debug(s);
    }

    @Override
    public void write(int b) {
        this.log(String.valueOf(b));
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        int i;
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        for (i = 0; i < len; ++i) {
            this.write(buf[off + i]);
        }
        for (i = 0; i < len; ++i) {
            this.write(buf[off + i]);
        }
    }

    private void write(byte b) {
        this.buffer.append(Byte.toString(b));
    }

    private void write(String s) {
        this.buffer.append(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            this.log(this.buffer.toString());
            this.buffer.delete(0, this.buffer.length());
        }
    }

    @Override
    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.write(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.write(String.valueOf(s));
    }

    @Override
    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    @Override
    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(boolean x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(int x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(long x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(float x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(double x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char[] x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(Object x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }
}

