/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.correlation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.transaction.UserTransaction;
import org.jbpm.persistence.JbpmTestCase;
import org.jbpm.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.KieInternalServices;
import org.kie.process.CorrelationKeyFactory;

public class CorrelationPersistenceTest
extends JbpmTestCase {
    private HashMap<String, Object> context;

    @Before
    public void before() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa", false);
        CorrelationKeyFactory factory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.persistence.jpa.EntityManagerFactory");
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        EntityManager em = emf.createEntityManager();
        em.persist((Object)factory.newCorrelationKey("test123"));
        ArrayList<String> props = new ArrayList<String>();
        props.add("test123");
        props.add("123test");
        em.persist((Object)factory.newCorrelationKey(props));
        ut.commit();
    }

    @After
    public void after() {
        try {
            EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.persistence.jpa.EntityManagerFactory");
            UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
            ut.begin();
            EntityManager em = emf.createEntityManager();
            em.createQuery("delete from CorrelationPropertyInfo").executeUpdate();
            em.createQuery("delete from CorrelationKeyInfo").executeUpdate();
            ut.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testCreateCorrelation() throws Exception {
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.persistence.jpa.EntityManagerFactory");
        EntityManager em = emf.createEntityManager();
        Query query = em.createNamedQuery("GetProcessInstanceIdByCorrelation");
        query.setParameter("properties", Arrays.asList("test123"));
        query.setParameter("elem_count", (Object)new Long(1L));
        List processInstances = query.getResultList();
        em.close();
        CorrelationPersistenceTest.assertNotNull((Object)processInstances);
        CorrelationPersistenceTest.assertEquals((int)1, (int)processInstances.size());
    }

    @Test
    public void testCreateCorrelationMultiValueDoesNotMatch() throws Exception {
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.persistence.jpa.EntityManagerFactory");
        EntityManager em = emf.createEntityManager();
        Query query = em.createNamedQuery("GetProcessInstanceIdByCorrelation");
        query.setParameter("properties", Arrays.asList("test123"));
        query.setParameter("elem_count", (Object)new Long(2L));
        List processInstances = query.getResultList();
        em.close();
        CorrelationPersistenceTest.assertNotNull((Object)processInstances);
        CorrelationPersistenceTest.assertEquals((int)0, (int)processInstances.size());
    }

    @Test
    public void testCreateCorrelationMultiValueDoesMatch() throws Exception {
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.persistence.jpa.EntityManagerFactory");
        EntityManager em = emf.createEntityManager();
        Query query = em.createNamedQuery("GetProcessInstanceIdByCorrelation");
        query.setParameter("properties", Arrays.asList("test123", "123test"));
        query.setParameter("elem_count", (Object)new Long(2L));
        List processInstances = query.getResultList();
        em.close();
        CorrelationPersistenceTest.assertNotNull((Object)processInstances);
        CorrelationPersistenceTest.assertEquals((int)1, (int)processInstances.size());
    }
}

