/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.drools.core.io.impl.ClassPathResource;
import org.jbpm.persistence.session.objects.TestWorkItemHandler;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class PersistentStatefulSessionTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(PersistentStatefulSessionTest.class);
    private HashMap<String, Object> context;
    private Environment env;
    @Rule
    public TestName testName = new TestName();
    private static String ruleString = "package org.drools.test\nglobal java.util.List list\nrule rule1\nwhen\n  Integer($i : intValue > 0)\nthen\n  list.add( $i );\nend\n\n";

    public PersistentStatefulSessionTest(boolean locking) {
        this.useLocking = locking;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    @Before
    public void setUp() throws Exception {
        String methodName = this.testName.getMethodName();
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
        if (this.useLocking) {
            this.env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testLocalTransactionPerStatement() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])ruleString.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testUserTransactions() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])ruleString.getBytes()), ResourceType.DRL);
        KieBaseConfiguration kBaseConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kBaseConf);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        ut.commit();
        ArrayList list = new ArrayList();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ut.rollback();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.fireAllRules();
        ut.commit();
        Assert.assertEquals((long)2L, (long)list.size());
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ksession.insert((Object)4);
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)5);
        ksession.insert((Object)6);
        ut.rollback();
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksession.getIdentifier(), (KieBase)kbase, null, (Environment)this.env);
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)7);
        ksession.insert((Object)8);
        ut.commit();
        ksession.fireAllRules();
        Assert.assertEquals((long)6L, (long)list.size());
    }

    @Test
    public void testPersistenceWorkItems() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("WorkItemsProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        int origNumObjects = ksession.getObjects().size();
        long id = ksession.getIdentifier();
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        ksession.insert((Object)"TestString");
        logger.debug("Started process instance {}", (Object)processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertEquals((long)(origNumObjects + 1), (long)ksession.getObjects().size());
        for (Object o : ksession.getObjects()) {
            logger.debug(o.toString());
        }
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testPersistenceWorkItems2() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("WorkItemsProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        long id = ksession.getIdentifier();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        ksession.insert((Object)"TestString");
        logger.debug("Started process instance {}", (Object)processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ut.commit();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        for (Object o : ksession.getObjects()) {
            logger.debug(o.toString());
        }
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testPersistenceWorkItems3() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("WorkItemsProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().registerWorkItemHandler("MyWork", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        ksession.insert((Object)"TestString");
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testPersistenceState() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("StateProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        long id = ksession.getIdentifier();
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        logger.debug("Started process instance {}", (Object)processInstance.getId());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession.insert(new ArrayList());
        ksession.fireAllRules();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testPersistenceEvents() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("EventsProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        long id = ksession.getIdentifier();
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        logger.debug("Started process instance {}", (Object)processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession.signalEvent("MyEvent1", null, processInstance.getId());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession.signalEvent("MyEvent2", null, processInstance.getId());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testProcessListener() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("WorkItemsProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        final ArrayList events = new ArrayList();
        ProcessEventListener listener = new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                logger.debug("After node left: {}", (Object)event.getNodeInstance().getNodeName());
                events.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                logger.debug("After node triggered: {}", (Object)event.getNodeInstance().getNodeName());
                events.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                logger.debug("After process completed");
                events.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                logger.debug("After process started");
                events.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                logger.debug("Before node left: {}", (Object)event.getNodeInstance().getNodeName());
                events.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                logger.debug("Before node triggered: {}", (Object)event.getNodeInstance().getNodeName());
                events.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                logger.debug("Before process completed");
                events.add(event);
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                logger.debug("Before process started");
                events.add(event);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                logger.debug("After Variable Changed");
                events.add(event);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                logger.debug("Before Variable Changed");
                events.add(event);
            }
        };
        ksession.addEventListener(listener);
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        logger.debug("Started process instance {}", (Object)processInstance.getId());
        Assert.assertEquals((long)12L, (long)events.size());
        Assert.assertTrue((boolean)(events.get(0) instanceof ProcessStartedEvent));
        Assert.assertTrue((boolean)(events.get(1) instanceof ProcessNodeTriggeredEvent));
        Assert.assertTrue((boolean)(events.get(2) instanceof ProcessNodeLeftEvent));
        Assert.assertTrue((boolean)(events.get(3) instanceof ProcessNodeTriggeredEvent));
        Assert.assertTrue((boolean)(events.get(4) instanceof ProcessNodeLeftEvent));
        Assert.assertTrue((boolean)(events.get(5) instanceof ProcessNodeTriggeredEvent));
        Assert.assertTrue((boolean)(events.get(6) instanceof ProcessNodeTriggeredEvent));
        Assert.assertTrue((boolean)(events.get(7) instanceof ProcessNodeLeftEvent));
        Assert.assertTrue((boolean)(events.get(8) instanceof ProcessNodeTriggeredEvent));
        Assert.assertTrue((boolean)(events.get(9) instanceof ProcessNodeLeftEvent));
        Assert.assertTrue((boolean)(events.get(10) instanceof ProcessNodeTriggeredEvent));
        Assert.assertTrue((boolean)(events.get(11) instanceof ProcessStartedEvent));
        ksession.removeEventListener(listener);
        events.clear();
        processInstance = ksession.startProcess("org.drools.test.TestProcess");
        logger.debug("Started process instance {}", (Object)processInstance.getId());
        Assert.assertTrue((boolean)events.isEmpty());
    }

    @Test
    public void testPersistenceSubProcess() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("SuperProcess.rf"), ResourceType.DRF);
        kbuilder.add((Resource)new ClassPathResource("SubProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        long id = ksession.getIdentifier();
        ProcessInstance processInstance = ksession.startProcess("com.sample.SuperProcess");
        logger.debug("Started process instance {}", (Object)processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((String)"Process did not complete.", (Object)processInstance);
    }

    @Test
    public void testPersistenceVariables() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("VariablesProcess.rf"), ResourceType.DRF);
        for (KnowledgeBuilderError error : kbuilder.getErrors()) {
            logger.debug(error.toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        long id = ksession.getIdentifier();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", "John Doe");
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess", parameters);
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"John Doe", (Object)workItem.getParameter("name"));
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"John Doe", (Object)workItem.getParameter("text"));
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testSetFocus() {
        String str = "";
        str = str + "package org.drools.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "agenda-group \"badfocus\"";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.getAgenda().getAgendaGroup("badfocus").setFocus();
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }
}

