/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.correlation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.transaction.UserTransaction;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKeyFactory;

@RunWith(value=Parameterized.class)
public class CorrelationPersistenceTest
extends AbstractBaseTest {
    private HashMap<String, Object> context;

    public CorrelationPersistenceTest(boolean locking) {
        this.useLocking = locking;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    @Before
    public void before() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        CorrelationKeyFactory factory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        try {
            EntityManager em = emf.createEntityManager();
            em.persist((Object)factory.newCorrelationKey("test123"));
            ArrayList<String> props = new ArrayList<String>();
            props.add("test123");
            props.add("123test");
            em.persist((Object)factory.newCorrelationKey(props));
            ut.commit();
        }
        catch (Exception ex) {
            ut.rollback();
            Assert.fail((String)"Exception thrown while trying to prepare correlation data.");
        }
    }

    @After
    public void after() throws Exception {
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        try {
            EntityManager em = emf.createEntityManager();
            em.createQuery("delete from CorrelationPropertyInfo").executeUpdate();
            em.createQuery("delete from CorrelationKeyInfo").executeUpdate();
            ut.commit();
        }
        catch (Exception ex) {
            ut.rollback();
            Assert.fail((String)"Exception thrown while trying to cleanup correlation data.");
        }
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testCreateCorrelation() throws Exception {
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        EntityManager em = emf.createEntityManager();
        Query query = em.createNamedQuery("GetProcessInstanceIdByCorrelation");
        query.setParameter("ckey", (Object)"test123");
        List processInstances = query.getResultList();
        em.close();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)1L, (long)processInstances.size());
    }

    @Test
    public void testCreateCorrelationMultiValueDoesNotMatch() throws Exception {
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        EntityManager em = emf.createEntityManager();
        Query query = em.createNamedQuery("GetProcessInstanceIdByCorrelation");
        query.setParameter("ckey", (Object)"test1234");
        List processInstances = query.getResultList();
        em.close();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)0L, (long)processInstances.size());
    }

    @Test
    public void testCreateCorrelationMultiValueDoesMatch() throws Exception {
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        EntityManager em = emf.createEntityManager();
        Query query = em.createNamedQuery("GetProcessInstanceIdByCorrelation");
        query.setParameter("ckey", (Object)"test123:123test");
        List processInstances = query.getResultList();
        em.close();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)1L, (long)processInstances.size());
    }
}

