/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.session;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class GetProcessInstancesTest
extends AbstractBaseTest {
    private HashMap<String, Object> context;
    private Environment env;
    private KieBase kbase;
    private long sessionId;

    public GetProcessInstancesTest(boolean locking) {
        this.useLocking = locking;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
        this.kbase = this.createBase();
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)this.kbase, null, (Environment)this.env);
        this.sessionId = ksession.getIdentifier();
        ksession.dispose();
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void getEmptyProcessInstances() throws Exception {
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        Assert.assertEquals((long)0L, (long)ksession.getProcessInstances().size());
        ksession.dispose();
    }

    @Test
    public void create2ProcessInstances() throws Exception {
        long[] processId = new long[2];
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        processId[0] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        processId[1] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        ksession.dispose();
        this.assertProcessInstancesExist(processId);
    }

    @Test
    public void create2ProcessInstancesInsideTransaction() throws Exception {
        long[] processId = new long[2];
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        processId[0] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        processId[1] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        Assert.assertEquals((long)2L, (long)ksession.getProcessInstances().size());
        ut.commit();
        Assert.assertEquals((long)0L, (long)ksession.getProcessInstances().size());
        ksession = this.reloadKnowledgeSession(ksession);
        Assert.assertEquals((long)0L, (long)ksession.getProcessInstances().size());
        ksession.dispose();
        this.assertProcessInstancesExist(processId);
    }

    @Test
    public void noProcessInstancesLeftAfterRollback() throws Exception {
        long[] notProcess = new long[2];
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        notProcess[0] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        notProcess[1] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        Assert.assertEquals((long)2L, (long)ksession.getProcessInstances().size());
        ut.rollback();
        Assert.assertEquals((long)0L, (long)ksession.getProcessInstances().size());
        ksession = this.reloadKnowledgeSession(ksession);
        Assert.assertEquals((long)0L, (long)ksession.getProcessInstances().size());
        ksession.dispose();
        this.assertProcessInstancesNotExist(notProcess);
    }

    @Test
    public void noProcessInstancesLeftWithPreTxKSessionAndRollback() throws Exception {
        long[] notProcess = new long[4];
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        notProcess[0] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        notProcess[1] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        ut.rollback();
        Assert.assertEquals((long)0L, (long)ksession.getProcessInstances().size());
        ksession = this.reloadKnowledgeSession(ksession);
        Assert.assertEquals((long)0L, (long)ksession.getProcessInstances().size());
        ksession.dispose();
        this.assertProcessInstancesNotExist(notProcess);
    }

    @Test
    public void createProcessInstanceAndGetStartDate() throws Exception {
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        long processId = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        Assert.assertEquals((long)0L, (long)ksession.getProcessInstances().size());
        RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)ksession.getProcessInstance(processId);
        Assert.assertNotNull((String)("Process " + processId + " exist!"), (Object)processInstance);
        Assert.assertNotNull((String)("Process start at " + processInstance.getStartDate()), (Object)processInstance.getStartDate());
        ksession.dispose();
    }

    @Test
    public void processInstanceWriteAfterReadonly1() throws Exception {
        this.internalProcessInstanceWriteAfterReadonly(false);
    }

    @Test
    public void processInstanceWriteAfterReadonly2() throws Exception {
        this.internalProcessInstanceWriteAfterReadonly(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalProcessInstanceWriteAfterReadonly(boolean checkVariable) throws Exception {
        long[] processId = new long[1];
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        processId[0] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        ksession.dispose();
        this.assertProcessInstancesExist(processId);
        String testVarName = "testVar" + processId;
        String testVarValue = UUID.randomUUID().toString();
        ReentrantLock lock = new ReentrantLock();
        AtomicBoolean thread1Waiting = new AtomicBoolean(true);
        AtomicBoolean thread2Waiting = new AtomicBoolean(true);
        Condition thread1Ready = lock.newCondition();
        Condition thread2Ready = lock.newCondition();
        Callable<Void> thread1Task = () -> {
            lock.lock();
            try {
                while (thread1Waiting.get()) {
                    thread2Ready.await();
                }
                UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                ut.begin();
                StatefulKnowledgeSession ksession1 = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)this.kbase, null, (Environment)PersistenceUtil.createEnvironment(this.context));
                RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)ksession1.getProcessInstance(processId[0], false);
                Assert.assertNotNull((Object)processInstance);
                processInstance.setVariable(testVarName, (Object)testVarValue);
                ut.commit();
                ksession1.dispose();
                thread2Waiting.set(false);
                thread1Ready.signal();
            }
            finally {
                lock.unlock();
            }
            return null;
        };
        Callable<Void> thread2Task = () -> {
            lock.lock();
            try {
                UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                ut.begin();
                StatefulKnowledgeSession ksession2 = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)this.kbase, null, (Environment)PersistenceUtil.createEnvironment(this.context));
                RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)ksession2.getProcessInstance(processId[0], true);
                Assert.assertNotNull((Object)processInstance);
                Assert.assertNull((Object)processInstance.getVariable(testVarName));
                thread1Waiting.set(false);
                thread2Ready.signal();
                while (thread2Waiting.get()) {
                    thread1Ready.await();
                }
                processInstance = (RuleFlowProcessInstance)ksession2.getProcessInstance(processId[0], false);
                Assert.assertNotNull((Object)processInstance);
                if (checkVariable) {
                    Assert.assertEquals((Object)testVarValue, (Object)processInstance.getVariable(testVarName));
                }
                ut.commit();
                ksession2.dispose();
            }
            finally {
                lock.unlock();
            }
            return null;
        };
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Future<Void> future1 = executor.submit(thread1Task);
            Future<Void> future2 = executor.submit(thread2Task);
            future1.get(1000L, TimeUnit.MILLISECONDS);
            future2.get(1000L, TimeUnit.MILLISECONDS);
        }
        finally {
            executor.shutdown();
        }
    }

    private void assertProcessInstancesExist(long[] processId) {
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        for (long id : processId) {
            Assert.assertNotNull((String)("Process instance " + id + " should not exist!"), (Object)ksession.getProcessInstance(id));
        }
    }

    private void assertProcessInstancesNotExist(long[] processId) {
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        for (long id : processId) {
            Assert.assertNull((Object)ksession.getProcessInstance(id));
        }
    }

    private KieBase createBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"processinstance/HelloWorld.rf"), ResourceType.DRF);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        return kbuilder.newKieBase();
    }

    private StatefulKnowledgeSession reloadKnowledgeSession() {
        return JPAKnowledgeService.loadStatefulKnowledgeSession((Long)this.sessionId, (KieBase)this.kbase, null, (Environment)this.env);
    }

    private StatefulKnowledgeSession reloadKnowledgeSession(StatefulKnowledgeSession ksession) {
        ksession.dispose();
        return this.reloadKnowledgeSession();
    }
}

