/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.cdi.impl;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcludeNonCDIImplExtension
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(ExcludeNonCDIImplExtension.class);
    private Set<String> excluded = new HashSet<String>();

    public ExcludeNonCDIImplExtension() {
        this.excluded.add("org.jbpm.kie.services.impl");
        this.excluded.add("org.jbpm.kie.services.impl.bpmn2");
        this.excluded.add("org.jbpm.kie.services.impl.form.FormProviderServiceImpl");
        this.excluded.add("org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl");
        this.excluded.add("org.jbpm.services.task.wih.ExternalTaskEventListener");
        this.excluded.add("org.jbpm.services.task.events.DefaultTaskEventListener");
        this.excluded.add("org.jbpm.kie.services.impl.store.DeploymentSynchronizer");
        this.excluded.add("org.jbpm.kie.services.impl.security.DeploymentRolesManager");
        this.excluded.add("org.jbpm.kie.services.impl.query.QueryServiceImpl");
        this.excluded.add("org.jbpm.kie.services.test.TestIdentityProvider");
    }

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> pat, BeanManager beanManager) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        Package pkg = javaClass.getPackage();
        if (pkg != null && this.excluded.contains(pkg.getName())) {
            logger.debug("jBPM CDI integration :: excluding package {}", (Object)pkg.getName());
            pat.veto();
        } else if (javaClass != null && this.excluded.contains(javaClass.getName())) {
            logger.debug("jBPM CDI integration :: excluding class {}" + javaClass.getName());
            pat.veto();
        }
    }
}

