/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.client;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.ejb.api.DefinitionServiceEJBRemote;
import org.jbpm.services.ejb.api.DeploymentServiceEJBRemote;
import org.jbpm.services.ejb.api.ProcessServiceEJBRemote;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBRemote;
import org.jbpm.services.ejb.api.UserTaskServiceEJBRemote;
import org.jbpm.services.ejb.client.ClientServiceFactory;
import org.jbpm.services.ejb.client.ServiceFactoryProvider;
import org.jbpm.services.ejb.client.helper.DeploymentServiceWrapper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.scanner.MavenRepository;

public class ClientEjbTimerServiceTest
extends AbstractKieServicesBaseTest {
    private static final String application = "sample-war-ejb-app";
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private static final String ARTIFACT_ID = "custom-data-project";
    private static final String GROUP_ID = "org.jbpm.test";
    private static final String VERSION = "1.0";
    private Long processInstanceId;

    @Before
    public void prepare() throws MalformedURLException {
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        File kjar = new File("src/test/resources/kjar/custom-data-project-1.0.jar");
        File pom = new File("src/test/resources/kjar/pom.xml");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId, kjar, pom);
    }

    @After
    public void cleanup() {
        if (this.processInstanceId != null) {
            this.processService.abortProcessInstance(this.processInstanceId);
        }
        ClientEjbTimerServiceTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    protected void close() {
    }

    @Before
    public void setup() {
        this.configureServices();
    }

    protected void configureServices() {
        try {
            ClientServiceFactory factory = ServiceFactoryProvider.getProvider((String)"JBoss");
            DeploymentServiceEJBRemote deploymentService = (DeploymentServiceEJBRemote)factory.getService(application, DeploymentServiceEJBRemote.class);
            ProcessServiceEJBRemote processService = (ProcessServiceEJBRemote)factory.getService(application, ProcessServiceEJBRemote.class);
            RuntimeDataServiceEJBRemote runtimeDataService = (RuntimeDataServiceEJBRemote)factory.getService(application, RuntimeDataServiceEJBRemote.class);
            DefinitionServiceEJBRemote definitionService = (DefinitionServiceEJBRemote)factory.getService(application, DefinitionServiceEJBRemote.class);
            UserTaskServiceEJBRemote userTaskService = (UserTaskServiceEJBRemote)factory.getService(application, UserTaskServiceEJBRemote.class);
            this.setBpmn2Service((DefinitionService)definitionService);
            this.setProcessService((ProcessService)processService);
            this.setRuntimeDataService((RuntimeDataService)runtimeDataService);
            this.setUserTaskService((UserTaskService)userTaskService);
            this.setDeploymentService(new DeploymentServiceWrapper(deploymentService));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to configure services");
        }
    }

    @Test
    public void testStartProcess() throws InterruptedException {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, VERSION);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("expiresAt", "2s");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "timer-test.timer-process", params);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Thread.sleep(3000L);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessWithHTDeadline() throws InterruptedException {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, VERSION);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        this.processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "htdeadlinetest");
        List krisTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("krisv", new QueryFilter());
        Assert.assertEquals((long)1L, (long)krisTasks.size());
        List johnTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assert.assertEquals((long)0L, (long)johnTasks.size());
        List maryTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
        Assert.assertEquals((long)0L, (long)maryTasks.size());
        Thread.sleep(3000L);
        krisTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("krisv", new QueryFilter());
        Assert.assertEquals((long)0L, (long)krisTasks.size());
        johnTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assert.assertEquals((long)1L, (long)johnTasks.size());
        maryTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
        Assert.assertEquals((long)0L, (long)maryTasks.size());
        this.userTaskService.start(((TaskSummary)johnTasks.get(0)).getId(), "john");
        Thread.sleep(2000L);
        krisTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("krisv", new QueryFilter());
        Assert.assertEquals((long)0L, (long)krisTasks.size());
        johnTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assert.assertEquals((long)1L, (long)johnTasks.size());
        maryTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
        Assert.assertEquals((long)0L, (long)maryTasks.size());
        Thread.sleep(3000L);
        krisTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("krisv", new QueryFilter());
        Assert.assertEquals((long)0L, (long)krisTasks.size());
        johnTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assert.assertEquals((long)0L, (long)johnTasks.size());
        maryTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
        Assert.assertEquals((long)1L, (long)maryTasks.size());
        this.userTaskService.start(((TaskSummary)maryTasks.get(0)).getId(), "mary");
        this.userTaskService.complete(((TaskSummary)maryTasks.get(0)).getId(), "mary", null);
        Thread.sleep(2000L);
        ProcessInstance processInstance = this.processService.getProcessInstance(this.processInstanceId);
        Assert.assertNull((Object)processInstance);
        this.processInstanceId = null;
    }
}

