/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.client;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.appformer.maven.support.ReleaseId;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.ejb.api.DefinitionServiceEJBRemote;
import org.jbpm.services.ejb.api.DeploymentServiceEJBRemote;
import org.jbpm.services.ejb.api.ProcessServiceEJBRemote;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBRemote;
import org.jbpm.services.ejb.api.UserTaskServiceEJBRemote;
import org.jbpm.services.ejb.client.ClientServiceFactory;
import org.jbpm.services.ejb.client.ServiceFactoryProvider;
import org.jbpm.services.ejb.client.helper.DeploymentServiceWrapper;
import org.jbpm.services.ejb.remote.api.RemoteMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.internal.query.QueryFilter;
import org.kie.scanner.KieMavenRepository;

public class ClientProcessServiceWithCustomDataEJBTest
extends AbstractKieServicesBaseTest {
    private static final String application = "sample-war-ejb-app";
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private static final String ARTIFACT_ID = "custom-data-project";
    private static final String GROUP_ID = "org.jbpm.test";
    private static final String VERSION = "1.0";
    private ClassLoader customClassLoader;
    private ClassLoader originClassLoader;
    private Long processInstanceId;

    @Before
    public void prepare() throws MalformedURLException {
        this.originClassLoader = Thread.currentThread().getContextClassLoader();
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        org.kie.api.builder.ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        File kjar = new File("src/test/resources/kjar/custom-data-project-1.0.jar");
        File pom = new File("src/test/resources/kjar/pom.xml");
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((ReleaseId)releaseId, kjar, pom);
        URL[] urls = new URL[]{kjar.toURI().toURL()};
        this.customClassLoader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
    }

    @After
    public void cleanup() {
        if (this.processInstanceId != null) {
            this.processService.abortProcessInstance(this.processInstanceId);
        }
        Thread.currentThread().setContextClassLoader(this.originClassLoader);
        ClientProcessServiceWithCustomDataEJBTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    protected void close() {
    }

    protected void configureServices() {
        try {
            ClientServiceFactory factory = ServiceFactoryProvider.getProvider((String)"JBoss");
            DeploymentServiceEJBRemote deploymentService = (DeploymentServiceEJBRemote)factory.getService(application, DeploymentServiceEJBRemote.class);
            ProcessServiceEJBRemote processService = (ProcessServiceEJBRemote)factory.getService(application, ProcessServiceEJBRemote.class);
            RuntimeDataServiceEJBRemote runtimeDataService = (RuntimeDataServiceEJBRemote)factory.getService(application, RuntimeDataServiceEJBRemote.class);
            DefinitionServiceEJBRemote definitionService = (DefinitionServiceEJBRemote)factory.getService(application, DefinitionServiceEJBRemote.class);
            UserTaskServiceEJBRemote userTaskService = (UserTaskServiceEJBRemote)factory.getService(application, UserTaskServiceEJBRemote.class);
            this.setBpmn2Service((DefinitionService)definitionService);
            this.setProcessService((ProcessService)processService);
            this.setRuntimeDataService((RuntimeDataService)runtimeDataService);
            this.setUserTaskService((UserTaskService)userTaskService);
            this.setDeploymentService(new DeploymentServiceWrapper(deploymentService));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to configure services", e);
        }
    }

    @Test
    public void testStartProcessWithCustomData() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, VERSION);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        RemoteMap parameters = new RemoteMap();
        Object person = this.getInstance("org.jbpm.test.Person", new Object[]{"john", 25, true});
        parameters.put("person", person);
        this.processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "custom-data-project.work-on-custom-data", (Map)parameters);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter(0, 10));
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        List tasks = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Long taskId = (Long)tasks.get(0);
        this.userTaskService.start(taskId, "john");
        Map data = this.userTaskService.getTaskInputContentByTaskId(taskId);
        Assert.assertNotNull((Object)data);
        Object fromTaskPerson = data.get("_person");
        Assert.assertNotNull(fromTaskPerson);
        Assert.assertEquals((Object)"john", (Object)this.getFieldValue(fromTaskPerson, "name"));
        this.setFieldValue(fromTaskPerson, "name", "John Doe");
        RemoteMap outcome = new RemoteMap();
        outcome.put("person_", fromTaskPerson);
        this.userTaskService.complete(taskId, "john", (Map)outcome);
        ProcessInstanceDesc desc = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((long)2L, (long)desc.getState().intValue());
        this.processInstanceId = null;
    }

    protected Object getInstance(String className, Object[] params) {
        try {
            Class<?> clazz = Class.forName(className, true, this.customClassLoader);
            if (params == null || params.length == 0) {
                return clazz.newInstance();
            }
            int i = 0;
            Class[] parameterTypes = new Class[params.length];
            for (Object o : params) {
                parameterTypes[i] = o.getClass();
                ++i;
            }
            Constructor<?> c = clazz.getConstructor(parameterTypes);
            return c.newInstance(params);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create instance of " + className, e);
        }
    }

    protected Object getFieldValue(Object object, String fieldName) {
        try {
            Field f = object.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get value for filed of " + fieldName, e);
        }
    }

    protected void setFieldValue(Object object, String fieldName, Object value) {
        try {
            Field f = object.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get value for filed of " + fieldName, e);
        }
    }
}

