/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.client.helper;

import java.util.Collection;
import java.util.function.Function;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.ejb.api.DeploymentServiceEJBRemote;
import org.kie.api.runtime.manager.RuntimeManager;

public class DeploymentServiceWrapper
implements DeploymentService {
    private DeploymentServiceEJBRemote remote;

    public DeploymentServiceWrapper(DeploymentServiceEJBRemote remote) {
        this.remote = remote;
    }

    public void deploy(DeploymentUnit unit) {
        KModuleDeploymentUnit kmoduleUnit = (KModuleDeploymentUnit)unit;
        this.remote.deploy(kmoduleUnit.getGroupId(), kmoduleUnit.getArtifactId(), kmoduleUnit.getVersion(), kmoduleUnit.getKbaseName(), kmoduleUnit.getKsessionName(), kmoduleUnit.getStrategy().toString());
    }

    public void undeploy(DeploymentUnit unit) {
        this.remote.undeploy(unit.getIdentifier());
    }

    public void undeploy(DeploymentUnit unit, Function<DeploymentUnit, Boolean> beforeUndeploy) {
        this.remote.undeploy(unit.getIdentifier(), beforeUndeploy);
    }

    public RuntimeManager getRuntimeManager(String deploymentUnitId) {
        throw new UnsupportedOperationException("Not supported");
    }

    public DeployedUnit getDeployedUnit(String deploymentUnitId) {
        throw new UnsupportedOperationException("Not supported");
    }

    public Collection<DeployedUnit> getDeployedUnits() {
        throw new UnsupportedOperationException("Not supported");
    }

    public void activate(String deploymentId) {
        this.remote.activate(deploymentId);
    }

    public void deactivate(String deploymentId) {
        this.remote.deactivate(deploymentId);
    }

    public boolean isDeployed(String deploymentUnitId) {
        return this.remote.isDeployed(deploymentUnitId);
    }
}

