/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.timer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.SessionContext;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerHandle;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.drools.core.time.JobHandle;
import org.drools.core.time.impl.TimerJobInstance;
import org.jbpm.persistence.timer.GlobalJpaTimerJobInstance;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.services.ejb.timer.EjbGlobalJobHandle;
import org.jbpm.services.ejb.timer.EjbTimerJob;
import org.jbpm.services.ejb.timer.EjbTimerJobRetry;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
@Lock(value=LockType.READ)
public class EJBTimerScheduler {
    private static final Logger logger = LoggerFactory.getLogger(EJBTimerScheduler.class);
    private static final Long TIMER_RETRY_INTERVAL = Long.parseLong(System.getProperty("org.kie.jbpm.timer.retry.interval", "5000"));
    private static final Integer TIMER_RETRY_LIMIT = Integer.parseInt(System.getProperty("org.kie.jbpm.timer.retry.limit", "3"));
    private static final Integer OVERDUE_WAIT_TIME = Integer.parseInt(System.getProperty("org.jbpm.overdue.timer.wait", "20000"));
    private static final Integer OVERDUE_CHECK_TIME = Integer.parseInt(System.getProperty("org.jbpm.overdue.timer.check", "200"));
    private boolean useLocalCache = Boolean.parseBoolean(System.getProperty("org.jbpm.ejb.timer.local.cache", "false"));
    private ConcurrentMap<String, TimerJobInstance> localCache = new ConcurrentHashMap<String, TimerJobInstance>();
    @Resource
    protected TimerService timerService;
    @Resource
    protected SessionContext ctx;

    public void setUseLocalCache(boolean useLocalCache) {
        this.useLocalCache = useLocalCache;
    }

    @PostConstruct
    public void setup() {
        System.setProperty("org.jbpm.rm.init.timer", "false");
        logger.info("Using local cache for EJB timers: {}", (Object)this.useLocalCache);
    }

    @Timeout
    public void executeTimerJob(Timer timer) {
        EjbTimerJob timerJob = (EjbTimerJob)timer.getInfo();
        TimerJobInstance timerJobInstance = timerJob.getTimerJobInstance();
        logger.debug("About to execute timer for job {}", (Object)timerJob);
        long time = 0L;
        try {
            while (TimerServiceRegistry.getInstance().get(((EjbGlobalJobHandle)timerJobInstance.getJobHandle()).getDeploymentId()) == null) {
                logger.debug("waiting for timer service to be available, elapsed time {} ms", (Object)time);
                Thread.sleep(OVERDUE_CHECK_TIME.intValue());
                if ((time += (long)OVERDUE_CHECK_TIME.intValue()) <= (long)OVERDUE_WAIT_TIME.intValue()) continue;
                logger.debug("No timer service found after waiting {} ms", (Object)time);
                break;
            }
        }
        catch (InterruptedException e) {
            logger.warn("Thread has been interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            this.executeTimerJobInstance(timerJobInstance);
        }
        catch (Exception e) {
            logger.error("Error executing timer handle {}", (Object)timerJobInstance.getJobHandle(), (Object)e);
            this.recoverTimerJobInstance(timerJob, timer, e);
        }
    }

    private void executeTimerJobInstance(TimerJobInstance timerJobInstance) throws Exception {
        ((Callable)timerJobInstance).call();
    }

    private void recoverTimerJobInstance(EjbTimerJob ejbTimerJob, Timer timer, Exception cause) {
        Transaction<TimerJobInstance> tx = this.isSessionNotFound(cause) ? timerJobInstance -> {
            logger.warn("Trying to recover timer. Not possible due to process instance is not found. More likely already completed. Timer {} won't be recovered", timerJobInstance, (Object)cause);
            if (!this.removeJob(timerJobInstance.getJobHandle(), timer)) {
                logger.warn("Session not found for timer {}. Timer could not removed.", timerJobInstance);
            }
        } : (ejbTimerJob.getTimerJobInstance().getTrigger().hasNextFireTime() != null ? timerJobInstance -> {
            logger.warn("Execution of time failed Interval Trigger failed. Skipping {}", timerJobInstance);
            if (this.removeJob(timerJobInstance.getJobHandle(), timer)) {
                this.internalSchedule((TimerJobInstance)timerJobInstance);
            } else {
                logger.debug("Interval trigger {} was removed before rescheduling", timerJobInstance);
            }
        } : timerJobInstance -> {
            EjbTimerJobRetry info;
            logger.warn("Execution of time failed. The timer will be retried {}", timerJobInstance);
            ZonedDateTime nextRetry = ZonedDateTime.now().plus(TIMER_RETRY_INTERVAL, ChronoUnit.MILLIS);
            EjbTimerJobRetry ejbTimerJobRetry = info = ejbTimerJob instanceof EjbTimerJobRetry ? ((EjbTimerJobRetry)ejbTimerJob).next() : new EjbTimerJobRetry((TimerJobInstance)timerJobInstance);
            if (TIMER_RETRY_LIMIT > 0 && info.getRetry() > TIMER_RETRY_LIMIT) {
                logger.warn("The timer {} reached retry limit {}. It won't be retried again", timerJobInstance, (Object)TIMER_RETRY_LIMIT);
            } else {
                TimerConfig config = new TimerConfig((Serializable)info, true);
                Timer newTimer = this.timerService.createSingleActionTimer(Date.from(nextRetry.toInstant()), config);
                ((GlobalJpaTimerJobInstance)timerJobInstance).setTimerInfo((Serializable)newTimer.getHandle());
                ((GlobalJpaTimerJobInstance)timerJobInstance).setExternalTimerId(this.getPlatformTimerId(newTimer));
            }
        });
        try {
            this.invokeTransaction(tx, ejbTimerJob.getTimerJobInstance());
        }
        catch (Exception e) {
            logger.error("Failed to executed timer recovery", (Throwable)e);
        }
    }

    private boolean isSessionNotFound(Exception e) {
        Throwable current = e;
        do {
            if (!(current instanceof SessionNotFoundException)) continue;
            return true;
        } while ((current = current.getCause()) != null);
        return false;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public <I> void transaction(Transaction<I> operation, I item) throws Exception {
        try {
            operation.doWork(item);
        }
        catch (Exception transactionEx) {
            this.ctx.setRollbackOnly();
            throw transactionEx;
        }
    }

    private <I> void invokeTransaction(Transaction<I> operation, I item) throws Exception {
        ((EJBTimerScheduler)this.ctx.getBusinessObject(EJBTimerScheduler.class)).transaction(operation, item);
    }

    public void internalSchedule(TimerJobInstance timerJobInstance) {
        Serializable info = this.removeTransientFields(new EjbTimerJob(timerJobInstance));
        TimerConfig config = new TimerConfig(info, true);
        Date expirationTime = timerJobInstance.getTrigger().hasNextFireTime();
        logger.debug("Timer expiration date is {}", (Object)expirationTime);
        if (expirationTime != null) {
            Timer timer = this.timerService.createSingleActionTimer(expirationTime, config);
            TimerHandle handle = timer.getHandle();
            ((GlobalJpaTimerJobInstance)timerJobInstance).setTimerInfo((Serializable)handle);
            logger.debug("Timer scheduled {} on {} scheduler service", (Object)timerJobInstance);
            ((GlobalJpaTimerJobInstance)timerJobInstance).setExternalTimerId(this.getPlatformTimerId(timer));
            if (this.useLocalCache) {
                this.localCache.putIfAbsent(((EjbGlobalJobHandle)timerJobInstance.getJobHandle()).getUuid(), timerJobInstance);
            }
        } else {
            logger.info("Timer that was to be scheduled has already expired");
        }
    }

    private String getPlatformTimerId(Timer timer) {
        try {
            Method method = timer.getClass().getMethod("getId", new Class[0]);
            return (String)method.invoke((Object)timer, new Object[0]);
        }
        catch (Exception timerIdException) {
            logger.trace("Failed to get the platform timer id {}", (Object)timerIdException.getMessage(), (Object)timerIdException);
            return null;
        }
    }

    private Serializable removeTransientFields(Serializable info) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(info);
            out.flush();
            ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            return (Serializable)stream.readObject();
        }
        catch (IOException io) {
            logger.warn("Not possible to serialize the timer info", (Throwable)io);
        }
        catch (ClassNotFoundException cnf) {
            logger.warn("Class not found in class loader", (Throwable)cnf);
        }
        return info;
    }

    private boolean disableLinearSearch(String suffix) {
        return Boolean.getBoolean("org.jbpm.ejb.timer.disable.linear." + suffix);
    }

    public boolean removeJob(JobHandle jobHandle, Timer ejbTimer) {
        Serializable ejbTimerHandle;
        EjbGlobalJobHandle ejbHandle = (EjbGlobalJobHandle)jobHandle;
        if (this.useLocalCache) {
            boolean removedFromCache = this.localCache.remove(ejbHandle.getUuid()) != null;
            logger.debug("Job handle {} is {} removed from cache ", (Object)jobHandle, (Object)(removedFromCache ? "" : "not"));
        }
        if (ejbTimer != null) {
            return this.cancelTimer(ejbTimer, ejbHandle);
        }
        GlobalJpaTimerJobInstance timerJobInstance = (GlobalJpaTimerJobInstance)ejbHandle.getTimerJobInstance();
        if (timerJobInstance != null && (ejbTimerHandle = timerJobInstance.getTimerInfo()) instanceof TimerHandle) {
            try {
                ((TimerHandle)ejbTimerHandle).getTimer().cancel();
                return true;
            }
            catch (Exception ex) {
                logger.warn("Cancelling timer failed for handle {}", (Object)ejbHandle, (Object)ex);
                return false;
            }
        }
        logger.debug("No valid TimerJob instance {} available for Job handle {}", (Object)timerJobInstance, (Object)ejbHandle);
        return this.linearSearch("remove", ejbHandle.getUuid(), (timer, job) -> this.cancelTimer((Timer)timer, (EjbGlobalJobHandle)job.getJobHandle())).orElse(false);
    }

    public TimerJobInstance getTimerByName(String jobName) {
        if (this.useLocalCache) {
            TimerJobInstance found = (TimerJobInstance)this.localCache.get(jobName);
            if (found != null) {
                logger.debug("Found timer job instance with  name {} in cache, returning {}", (Object)jobName, (Object)found);
                return found;
            }
            logger.debug("Timer Job Instance with name {} not found in cache", (Object)jobName);
        }
        return this.linearSearch("search", jobName, (timer, job) -> {
            if (this.useLocalCache && job != null) {
                this.localCache.putIfAbsent(jobName, (TimerJobInstance)job);
            }
            return job;
        }).orElse(null);
    }

    private boolean cancelTimer(Timer timer, EjbGlobalJobHandle ejbHandle) {
        try {
            timer.cancel();
            return true;
        }
        catch (Exception ex) {
            logger.warn("Cancelling timer failed for handle {}", (Object)ejbHandle, (Object)ex);
            return false;
        }
    }

    private <T> Optional<T> linearSearch(String suffix, String uuid, BiFunction<Timer, TimerJobInstance, T> function) {
        if (this.disableLinearSearch(suffix)) {
            logger.warn("Skipping linear search to {} UUID {}", (Object)suffix, (Object)uuid);
        } else {
            logger.info("Searching UUID {} on {} scheduler service", (Object)uuid, (Object)this);
            for (Timer timer : this.timerService.getTimers()) {
                try {
                    EjbTimerJob job;
                    EjbGlobalJobHandle handle;
                    Serializable info = timer.getInfo();
                    if (!(info instanceof EjbTimerJob) || !(handle = (EjbGlobalJobHandle)(job = (EjbTimerJob)info).getTimerJobInstance().getJobHandle()).getUuid().equals(uuid)) continue;
                    logger.debug("UIID {} does match timer {} and handle {}", new Object[]{uuid, timer, job.getTimerJobInstance()});
                    return Optional.ofNullable(function.apply(timer, job.getTimerJobInstance()));
                }
                catch (NoSuchObjectLocalException e) {
                    logger.info("Info for timer {} is not there ", (Object)timer, (Object)e);
                }
            }
            logger.info("UUID {} does not match any timer on {} scheduler service", (Object)uuid, (Object)this);
        }
        return Optional.empty();
    }

    public void evictCache(JobHandle jobHandle) {
        String jobName = ((EjbGlobalJobHandle)jobHandle).getUuid();
        logger.debug("Invalidate job {} with job name {} in cache", this.localCache.remove(jobName), (Object)jobName);
    }

    @FunctionalInterface
    private static interface Transaction<I> {
        public void doWork(I var1) throws Exception;
    }
}

