/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.shared.services.impl;

import java.io.OutputStream;
import java.net.URI;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jbpm.shared.services.api.FileException;
import org.jbpm.shared.services.api.FileService;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.commons.validation.PortablePreconditions;

@Singleton
public class VFSFileServiceImpl
implements FileService {
    private static final String REPO_PLAYGROUND = "git://jbpm-playground/";
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    @Override
    @PostConstruct
    public void init() {
        this.fetchChanges();
    }

    @Override
    public void fetchChanges() {
        this.ioService.getFileSystem(URI.create("git://jbpm-playground/?fetch"));
    }

    @Override
    public byte[] loadFile(Path file) throws FileException {
        PortablePreconditions.checkNotNull((String)"file", (Object)file);
        try {
            return this.ioService.readAllBytes(file);
        }
        catch (IOException ex) {
            throw new FileException(ex.getMessage(), ex);
        }
    }

    @Override
    public Iterable<Path> loadFilesByType(Path path, final String fileType) {
        return this.ioService.newDirectoryStream(path, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]) && (entry.getFileName().toString().endsWith(fileType) || entry.getFileName().toString().matches(fileType));
            }
        });
    }

    @Override
    public Iterable<Path> listDirectories(Path path) {
        return this.ioService.newDirectoryStream(path, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]);
            }
        });
    }

    @Override
    public Path getPath(String path) {
        return this.ioService.get(path, new String[0]);
    }

    @Override
    public boolean exists(Path file) {
        return this.ioService.exists(file);
    }

    @Override
    public void move(Path source, Path dest) {
        this.copy(source, dest);
        this.ioService.delete(source);
    }

    @Override
    public void copy(Path source, Path dest) {
        PortablePreconditions.checkNotNull((String)"source", (Object)source);
        PortablePreconditions.checkNotNull((String)"dest", (Object)dest);
        this.ioService.copy(source, dest, new CopyOption[0]);
    }

    @Override
    public Path createDirectory(Path path) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this.ioService.createDirectory(path, new FileAttribute[0]);
    }

    @Override
    public Path createFile(Path path) {
        return this.ioService.createFile(path, new FileAttribute[0]);
    }

    @Override
    public boolean deleteIfExists(Path path) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this.ioService.deleteIfExists(path);
    }

    @Override
    public OutputStream openFile(Path path) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this.ioService.newOutputStream(path, new OpenOption[0]);
    }
}

