/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.shared.services.impl;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.drools.persistence.TransactionSynchronization;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.jbpm.shared.services.api.JbpmServicesTransactionManager;
import org.jbpm.shared.services.impl.JbpmJTATransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JbpmServicesPersistenceManagerImpl
implements JbpmServicesPersistenceManager {
    private static final Logger logger = LoggerFactory.getLogger(JbpmServicesPersistenceManagerImpl.class);
    private JbpmServicesTransactionManager ttxm;
    @Inject
    private EntityManager em;
    @Inject
    private EntityManagerFactory emf;
    private static ThreadLocal<LocalEntityMangerHolder> noScopeEmLocal = new ThreadLocal();
    private boolean sharedEntityManager = false;
    public static final String FIRST_RESULT = "firstResult";
    public static final String MAX_RESULTS = "maxResults";

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public void setUseSharedEntityManager(boolean sharedEntityManager) {
        this.sharedEntityManager = sharedEntityManager;
    }

    public boolean isSharedEntityManager() {
        return this.sharedEntityManager;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void setTransactionManager(JbpmServicesTransactionManager ttxm) {
        this.ttxm = ttxm;
    }

    public boolean hasTransactionManager() {
        return this.ttxm != null;
    }

    @Override
    public int executeUpdateString(String updateString) {
        boolean txOwner = false;
        boolean operationSuccessful = false;
        boolean txStarted = false;
        int result = 0;
        try {
            txOwner = this.beginTransaction();
            txStarted = true;
            result = this.getEm().createQuery(updateString).executeUpdate();
            operationSuccessful = true;
            this.endTransaction(txOwner);
        }
        catch (Exception e) {
            this.rollBackTransaction(txOwner);
            String message = !txStarted ? "Could not start transaction." : (!operationSuccessful ? "Operation failed" : "Could not commit transaction");
            throw new RuntimeException(message, e);
        }
        return result;
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        Object find = null;
        if (this.ttxm != null) {
            this.ttxm.attachPersistenceContext(this.getEm());
        }
        find = this.getEm().find(entityClass, primaryKey);
        return (T)find;
    }

    @Override
    public void remove(Object entity) {
        boolean txOwner = false;
        boolean operationSuccessful = false;
        boolean txStarted = false;
        try {
            txOwner = this.beginTransaction();
            txStarted = true;
            this.getEm().remove(entity);
            operationSuccessful = true;
            this.endTransaction(txOwner);
        }
        catch (Exception e) {
            this.rollBackTransaction(txOwner);
            String message = !txStarted ? "Could not start transaction." : (!operationSuccessful ? "Operation failed" : "Could not commit transaction");
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public void persist(Object entity) {
        boolean txOwner = false;
        boolean operationSuccessful = false;
        boolean txStarted = false;
        try {
            txOwner = this.beginTransaction();
            txStarted = true;
            this.getEm().persist(entity);
            operationSuccessful = true;
            this.endTransaction(txOwner);
        }
        catch (Exception e) {
            this.rollBackTransaction(txOwner);
            String message = !txStarted ? "Could not start transaction." : (!operationSuccessful ? "Operation failed" : "Could not commit transaction");
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public <T> T merge(T entity) {
        boolean txOwner = false;
        boolean operationSuccessful = false;
        boolean txStarted = false;
        Object mergedEntity = null;
        try {
            txOwner = this.beginTransaction();
            txStarted = true;
            mergedEntity = this.getEm().merge(entity);
            operationSuccessful = true;
            this.endTransaction(txOwner);
        }
        catch (Exception e) {
            this.rollBackTransaction(txOwner);
            String message = !txStarted ? "Could not start transaction." : (!operationSuccessful ? "Operation failed" : "Could not commit transaction");
            throw new RuntimeException(message, e);
        }
        return (T)mergedEntity;
    }

    @Override
    public Object queryAndLockStringWithParametersInTransaction(String queryString, Map<String, Object> params, boolean singleResult) {
        Object result = null;
        boolean txOwner = false;
        boolean operationSuccessful = false;
        boolean txStarted = false;
        try {
            txOwner = this.beginTransaction();
            txStarted = true;
            result = this.queryStringWithParameters(queryString, params, singleResult, LockModeType.PESSIMISTIC_WRITE);
            operationSuccessful = true;
            this.endTransaction(txOwner);
        }
        catch (Exception e) {
            this.rollBackTransaction(txOwner);
            String message = !txStarted ? "Could not start transaction." : (!operationSuccessful ? "Operation failed" : "Could not commit transaction");
            throw new RuntimeException(message, e);
        }
        return result;
    }

    @Override
    public Object queryStringWithParametersInTransaction(String queryString, Map<String, Object> params) {
        Object result = null;
        boolean txOwner = false;
        boolean operationSuccessful = false;
        boolean txStarted = false;
        try {
            txOwner = this.beginTransaction();
            txStarted = true;
            result = this.queryStringWithParameters(queryString, params, false, null);
            operationSuccessful = true;
            this.endTransaction(txOwner);
        }
        catch (Exception e) {
            this.rollBackTransaction(txOwner);
            String message = !txStarted ? "Could not start transaction." : (!operationSuccessful ? "Operation failed" : "Could not commit transaction");
            throw new RuntimeException(message, e);
        }
        return result;
    }

    @Override
    public Object queryStringInTransaction(String queryString) {
        return this.queryStringWithParametersInTransaction(queryString, null);
    }

    @Override
    public boolean beginTransaction() {
        if (this.ttxm != null) {
            boolean txOwner = this.ttxm.begin(this.getEm());
            this.ttxm.attachPersistenceContext(this.getEm());
            this.registerTxSync();
            return txOwner;
        }
        this.registerTxSync();
        return false;
    }

    @Override
    public void endTransaction(boolean txOwner) {
        if (this.ttxm != null) {
            try {
                this.ttxm.commit(this.getEm(), txOwner);
            }
            catch (RuntimeException re) {
                logger.error("Unable to commit, rolling back transaction.", (Throwable)re);
                this.ttxm.rollback(this.getEm(), txOwner);
                throw re;
            }
            finally {
                if (!this.ttxm.supportsTXSynchronization() && txOwner) {
                    noScopeEmLocal.set(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollBackTransaction(boolean txOwner) {
        if (this.ttxm != null) {
            try {
                this.ttxm.rollback(this.getEm(), txOwner);
            }
            catch (RuntimeException re) {
                logger.error("Unable to rollback transaction (or to mark as 'to rollback')!", (Throwable)re);
            }
            finally {
                if (!this.ttxm.supportsTXSynchronization() && txOwner) {
                    noScopeEmLocal.set(null);
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.endPersistenceContext();
    }

    public void endPersistenceContext() {
        if (this.getEm() == null) {
            this.ttxm = null;
            return;
        }
        if (this.sharedEntityManager) {
            return;
        }
        boolean closeEm = this.getEm().isOpen();
        if (closeEm) {
            try {
                this.ttxm.dispose();
                this.getEm().clear();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.getEm().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.em = null;
        noScopeEmLocal.set(null);
        this.ttxm = null;
    }

    public EntityManager getEm() {
        try {
            if (this.em != null) {
                this.em.toString();
                return this.em;
            }
            return this.getLocalEntityManager();
        }
        catch (ContextNotActiveException e) {
            return this.getLocalEntityManager();
        }
    }

    protected EntityManager getLocalEntityManager() {
        LocalEntityMangerHolder noScopeEntityManager = noScopeEmLocal.get();
        logger.debug("No entity manager available trying to use no scoped entity manager {}", (Object)noScopeEntityManager);
        if (noScopeEntityManager == null) {
            noScopeEntityManager = new LocalEntityMangerHolder(this.emf.createEntityManager());
            logger.debug("local (no scoped) entity manager was not set, creating new entity manager {}", (Object)noScopeEntityManager);
            noScopeEmLocal.set(noScopeEntityManager);
        }
        return noScopeEntityManager.getEntityManager();
    }

    public Object queryWithParametersInTransaction(String queryName, Map<String, Object> params, boolean singleResult) {
        Object result = null;
        boolean txOwner = false;
        boolean operationSuccessful = false;
        boolean txStarted = false;
        try {
            txOwner = this.beginTransaction();
            txStarted = true;
            result = this.queryWithParameters(queryName, params, singleResult, null);
            operationSuccessful = true;
            this.endTransaction(txOwner);
        }
        catch (Exception e) {
            this.rollBackTransaction(txOwner);
            String message = !txStarted ? "Could not start transaction." : (!operationSuccessful ? "Operation failed" : "Could not commit transaction");
            throw new RuntimeException(message, e);
        }
        return result;
    }

    @Override
    public Object queryAndLockWithParametersInTransaction(String queryName, Map<String, Object> params, boolean singleResult) {
        Object result = null;
        boolean txOwner = false;
        boolean operationSuccessful = false;
        boolean txStarted = false;
        try {
            txOwner = this.beginTransaction();
            txStarted = true;
            result = this.queryWithParameters(queryName, params, singleResult, LockModeType.PESSIMISTIC_WRITE);
            operationSuccessful = true;
            this.endTransaction(txOwner);
        }
        catch (NoResultException e) {
            this.endTransaction(txOwner);
            throw e;
        }
        catch (Exception e) {
            this.rollBackTransaction(txOwner);
            String message = !txStarted ? "Could not start transaction." : (!operationSuccessful ? "Operation failed" : "Could not commit transaction");
            throw new RuntimeException(message, e);
        }
        return result;
    }

    @Override
    public Object queryWithParametersInTransaction(String queryName, Map<String, Object> params) {
        return this.queryWithParametersInTransaction(queryName, params, false);
    }

    @Override
    public Object queryInTransaction(String queryName) {
        return this.queryWithParametersInTransaction(queryName, null, false);
    }

    private Object queryWithParameters(String queryName, Map<String, Object> params, boolean singleResult, LockModeType lockMode) {
        Query query = this.getEm().createNamedQuery(queryName);
        if (lockMode != null) {
            query.setLockMode(lockMode);
        }
        if (params != null && !params.isEmpty()) {
            for (String name : params.keySet()) {
                if (FIRST_RESULT.equals(name)) {
                    query.setFirstResult(((Integer)params.get(name)).intValue());
                    continue;
                }
                if (MAX_RESULTS.equals(name)) {
                    query.setMaxResults(((Integer)params.get(name)).intValue());
                    continue;
                }
                query.setParameter(name, params.get(name));
            }
        }
        if (singleResult) {
            return query.getSingleResult();
        }
        return query.getResultList();
    }

    private Object queryStringWithParameters(String string, Map<String, Object> params, boolean singleResult, LockModeType lockMode) {
        Query query = this.getEm().createQuery(string);
        if (lockMode != null) {
            query.setLockMode(lockMode);
        }
        if (params != null && !params.isEmpty()) {
            for (String name : params.keySet()) {
                if (FIRST_RESULT.equals(name)) {
                    query.setFirstResult(((Integer)params.get(name)).intValue());
                    continue;
                }
                if (MAX_RESULTS.equals(name)) {
                    query.setMaxResults(((Integer)params.get(name)).intValue());
                    continue;
                }
                query.setParameter(name, params.get(name));
            }
        }
        if (singleResult) {
            return query.getSingleResult();
        }
        return query.getResultList();
    }

    @Override
    public HashMap<String, Object> addParametersToMap(Object ... parameterValues) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (parameterValues.length % 2 != 0) {
            throw new RuntimeException("Expected an even number of parameters, not " + parameterValues.length);
        }
        for (int i = 0; i < parameterValues.length; ++i) {
            String parameterName = null;
            if (!(parameterValues[i] instanceof String)) {
                throw new RuntimeException("Expected a String as the parameter name, not a " + parameterValues[i].getClass().getSimpleName());
            }
            parameterName = (String)parameterValues[i];
            parameters.put(parameterName, parameterValues[++i]);
        }
        return parameters;
    }

    private void registerTxSync() {
        LocalEntityMangerHolder holder = noScopeEmLocal.get();
        if (holder != null && !holder.isRegistered()) {
            logger.debug("Registering transaction sync for local (no scoped) entity manager");
            JbpmServicesTransactionManager txManager = this.ttxm;
            if (txManager == null) {
                txManager = new JbpmJTATransactionManager();
            }
            txManager.registerTXSynchronization(new TransactionSynchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    logger.debug("Cleaning local (no scoped) entity manager on tx completion");
                    noScopeEmLocal.set(null);
                }
            });
            holder.setRegistered(true);
        }
    }

    private class LocalEntityMangerHolder {
        private boolean registered;
        private EntityManager entityManager;

        public LocalEntityMangerHolder(EntityManager em) {
            this.entityManager = em;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public void setRegistered(boolean registered) {
            this.registered = registered;
        }

        public EntityManager getEntityManager() {
            return this.entityManager;
        }

        public String toString() {
            return "LocalEntityMangerHolder [registered=" + this.registered + ", entityManager=" + this.entityManager + "]";
        }
    }
}

