/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.shared.services.impl;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalCommandService
implements CommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(TransactionalCommandService.class);
    protected EntityManagerFactory emf;
    private Context context;
    private TransactionManager txm;

    public TransactionalCommandService(EntityManagerFactory emf, TransactionManager txm) {
        this.emf = emf;
        this.txm = txm;
    }

    public TransactionalCommandService(EntityManagerFactory emf) {
        this(emf, TransactionManagerFactory.get().newTransactionManager());
    }

    public Context getContext() {
        return this.context;
    }

    public TransactionManager getTransactionManager() {
        return this.txm;
    }

    protected void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public <T> T execute(Command<T> command) {
        boolean transactionOwner = false;
        boolean emOwner = false;
        Object result = null;
        try {
            transactionOwner = this.txm.begin();
            EntityManager em = this.getEntityManager(command);
            if (em == null) {
                em = this.emf.createEntityManager();
                emOwner = true;
            }
            JpaPersistenceContext context = new JpaPersistenceContext(em);
            context.joinTransaction();
            result = ((ExecutableCommand)command).execute((Context)context);
            this.txm.commit(transactionOwner);
            context.close(transactionOwner, emOwner);
            return (T)result;
        }
        catch (RuntimeException re) {
            this.rollbackTransaction(re, transactionOwner);
            throw re;
        }
        catch (Exception t1) {
            this.rollbackTransaction(t1, transactionOwner);
            throw new RuntimeException("Wrapped exception see cause", t1);
        }
    }

    private void rollbackTransaction(Exception t1, boolean transactionOwner) {
        try {
            logger.warn("Could not commit session", (Throwable)t1);
            this.txm.rollback(transactionOwner);
        }
        catch (Exception t2) {
            logger.error("Could not rollback", (Throwable)t2);
            throw new RuntimeException("Could not commit session or rollback", t2);
        }
    }

    protected EntityManager getEntityManager(Command<?> command) {
        EntityManager em = (EntityManager)this.txm.getResource((Object)"org.kie.api.persistence.jpa.CmdScopedEntityManager");
        if (em != null && em.isOpen() && em.getEntityManagerFactory().equals(this.emf)) {
            return em;
        }
        return null;
    }
}

